/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.environments;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.tomitribe.crest.environments.Environment;

public class SystemEnvironment
implements Environment {
    private final Map<Class<?>, Object> services;

    public SystemEnvironment(Map<Class<?>, Object> services) {
        this.services = services;
    }

    public SystemEnvironment() {
        this.services = Collections.emptyMap();
    }

    @Override
    public PrintStream getOutput() {
        return System.out;
    }

    @Override
    public PrintStream getError() {
        return System.err;
    }

    @Override
    public InputStream getInput() {
        return System.in;
    }

    @Override
    public Properties getProperties() {
        return System.getProperties();
    }

    @Override
    public <T> T findService(Class<T> type) {
        return type.cast(this.services.get(type));
    }
}

