/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.interceptor.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.tomitribe.crest.api.interceptor.CrestContext;
import org.tomitribe.crest.api.interceptor.ParameterMetadata;
import org.tomitribe.crest.interceptor.internal.InternalInterceptor;

public abstract class InternalInterceptorInvocationContext {
    private final Map<Class<?>, InternalInterceptor> interceptors;
    private final CrestContext context;
    private final Class<?>[] interceptorKeys;
    private List<Object> parameters;
    private int index = 0;

    public InternalInterceptorInvocationContext(Map<Class<?>, InternalInterceptor> interceptors, Class<?>[] interceptorKeys, final String name, final List<ParameterMetadata> parameterMetadatas, final Method method, final List<Object> parameters) {
        this.interceptorKeys = interceptorKeys;
        this.interceptors = interceptors;
        this.parameters = parameters;
        this.context = new CrestContext(){

            public Object proceed() {
                return InternalInterceptorInvocationContext.this.proceed();
            }

            public Method getMethod() {
                return method;
            }

            public List<Object> getParameters() {
                return parameters;
            }

            public String getName() {
                return name;
            }

            public List<ParameterMetadata> getParameterMetadata() {
                return parameterMetadatas;
            }
        };
    }

    public Object proceed() {
        if (this.index < this.interceptorKeys.length) {
            InternalInterceptor internalInterceptor = this.interceptors.get(this.interceptorKeys[this.index]);
            if (internalInterceptor == null) {
                throw new IllegalArgumentException("No interceptor for " + this.interceptorKeys[this.index].getName());
            }
            ++this.index;
            return internalInterceptor.intercept(this.context);
        }
        return this.doInvoke(this.parameters);
    }

    protected abstract Object doInvoke(List<Object> var1);
}

