/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.interceptor.security;

import javax.annotation.security.RolesAllowed;
import org.tomitribe.crest.api.interceptor.CrestContext;
import org.tomitribe.crest.api.interceptor.CrestInterceptor;
import org.tomitribe.crest.environments.Environment;
import org.tomitribe.crest.interceptor.security.RoleProvider;

public class SecurityInterceptor {
    @CrestInterceptor
    public Object secure(CrestContext crestContext) {
        RolesAllowed rolesAllowed = crestContext.getMethod().getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            RoleProvider provider = Environment.ENVIRONMENT_THREAD_LOCAL.get().findService(RoleProvider.class);
            if (provider == null) {
                throw new IllegalStateException("No RoleProvider registered, security interceptor can't work.");
            }
            for (String role : rolesAllowed.value()) {
                if (!provider.hasRole(role)) continue;
                return crestContext.proceed();
            }
            throw new IllegalArgumentException("User is not allowed to perform this operation");
        }
        return crestContext.proceed();
    }
}

