/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.term;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.stream.Stream;
import org.tomitribe.crest.table.Lines;

public class Screen {
    private Screen() {
    }

    public static String exec() throws IOException {
        return Screen.exec(true, "stty", "-a");
    }

    public static int guessWidth() {
        try {
            return Screen.parseWidth(Screen.exec());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int parseWidth(String output) {
        return Stream.of(Lines.split(output)).filter(s -> s.contains(" columns;")).map(s -> s.split(";")).flatMap(Stream::of).map(String::trim).filter(s -> s.endsWith(" columns")).map(s -> s.split("[= ]+")).filter(strings -> ((String[])strings).length == 2).map(strings -> strings[0]).map(String::trim).map(Integer::parseInt).findFirst().orElse(-1);
    }

    public static String exec(boolean redirectInput, String ... cmd) throws IOException {
        Objects.requireNonNull(cmd);
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd);
            if (redirectInput) {
                pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
            }
            Process p = pb.start();
            String result = Screen.waitAndCapture(p);
            if (p.exitValue() != 0) {
                if (result.endsWith("\n")) {
                    result = result.substring(0, result.length() - 1);
                }
                throw new IOException("Error executing '" + String.join((CharSequence)" ", cmd) + "': " + result);
            }
            return result;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException("Command interrupted").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String waitAndCapture(Process p) throws IOException, InterruptedException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        InputStream in = null;
        InputStream err = null;
        OutputStream out = null;
        try {
            int c;
            in = p.getInputStream();
            while ((c = in.read()) != -1) {
                bout.write(c);
            }
            err = p.getErrorStream();
            while ((c = err.read()) != -1) {
                bout.write(c);
            }
            out = p.getOutputStream();
            p.waitFor();
        }
        catch (Throwable throwable) {
            Screen.close(in, out, err);
            throw throwable;
        }
        Screen.close(in, out, err);
        return bout.toString();
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

