/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType;
import software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType;
import software.amazon.awssdk.services.applicationautoscaling.model.StepAdjustment;
import software.amazon.awssdk.services.applicationautoscaling.model.StepAdjustmentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepScalingPolicyConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepScalingPolicyConfiguration> {
    private static final SdkField<String> ADJUSTMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdjustmentType").getter(StepScalingPolicyConfiguration.getter(StepScalingPolicyConfiguration::adjustmentTypeAsString)).setter(StepScalingPolicyConfiguration.setter(Builder::adjustmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdjustmentType").build()}).build();
    private static final SdkField<List<StepAdjustment>> STEP_ADJUSTMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StepAdjustments").getter(StepScalingPolicyConfiguration.getter(StepScalingPolicyConfiguration::stepAdjustments)).setter(StepScalingPolicyConfiguration.setter(Builder::stepAdjustments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepAdjustments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepAdjustment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MIN_ADJUSTMENT_MAGNITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinAdjustmentMagnitude").getter(StepScalingPolicyConfiguration.getter(StepScalingPolicyConfiguration::minAdjustmentMagnitude)).setter(StepScalingPolicyConfiguration.setter(Builder::minAdjustmentMagnitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinAdjustmentMagnitude").build()}).build();
    private static final SdkField<Integer> COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Cooldown").getter(StepScalingPolicyConfiguration.getter(StepScalingPolicyConfiguration::cooldown)).setter(StepScalingPolicyConfiguration.setter(Builder::cooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cooldown").build()}).build();
    private static final SdkField<String> METRIC_AGGREGATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricAggregationType").getter(StepScalingPolicyConfiguration.getter(StepScalingPolicyConfiguration::metricAggregationTypeAsString)).setter(StepScalingPolicyConfiguration.setter(Builder::metricAggregationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricAggregationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADJUSTMENT_TYPE_FIELD, STEP_ADJUSTMENTS_FIELD, MIN_ADJUSTMENT_MAGNITUDE_FIELD, COOLDOWN_FIELD, METRIC_AGGREGATION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adjustmentType;
    private final List<StepAdjustment> stepAdjustments;
    private final Integer minAdjustmentMagnitude;
    private final Integer cooldown;
    private final String metricAggregationType;

    private StepScalingPolicyConfiguration(BuilderImpl builder) {
        this.adjustmentType = builder.adjustmentType;
        this.stepAdjustments = builder.stepAdjustments;
        this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
        this.cooldown = builder.cooldown;
        this.metricAggregationType = builder.metricAggregationType;
    }

    public final AdjustmentType adjustmentType() {
        return AdjustmentType.fromValue(this.adjustmentType);
    }

    public final String adjustmentTypeAsString() {
        return this.adjustmentType;
    }

    public final boolean hasStepAdjustments() {
        return this.stepAdjustments != null && !(this.stepAdjustments instanceof SdkAutoConstructList);
    }

    public final List<StepAdjustment> stepAdjustments() {
        return this.stepAdjustments;
    }

    public final Integer minAdjustmentMagnitude() {
        return this.minAdjustmentMagnitude;
    }

    public final Integer cooldown() {
        return this.cooldown;
    }

    public final MetricAggregationType metricAggregationType() {
        return MetricAggregationType.fromValue(this.metricAggregationType);
    }

    public final String metricAggregationTypeAsString() {
        return this.metricAggregationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adjustmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepAdjustments() ? this.stepAdjustments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minAdjustmentMagnitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.cooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAggregationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepScalingPolicyConfiguration)) {
            return false;
        }
        StepScalingPolicyConfiguration other = (StepScalingPolicyConfiguration)obj;
        return Objects.equals(this.adjustmentTypeAsString(), other.adjustmentTypeAsString()) && this.hasStepAdjustments() == other.hasStepAdjustments() && Objects.equals(this.stepAdjustments(), other.stepAdjustments()) && Objects.equals(this.minAdjustmentMagnitude(), other.minAdjustmentMagnitude()) && Objects.equals(this.cooldown(), other.cooldown()) && Objects.equals(this.metricAggregationTypeAsString(), other.metricAggregationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StepScalingPolicyConfiguration").add("AdjustmentType", (Object)this.adjustmentTypeAsString()).add("StepAdjustments", this.hasStepAdjustments() ? this.stepAdjustments() : null).add("MinAdjustmentMagnitude", (Object)this.minAdjustmentMagnitude()).add("Cooldown", (Object)this.cooldown()).add("MetricAggregationType", (Object)this.metricAggregationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdjustmentType": {
                return Optional.ofNullable(clazz.cast(this.adjustmentTypeAsString()));
            }
            case "StepAdjustments": {
                return Optional.ofNullable(clazz.cast(this.stepAdjustments()));
            }
            case "MinAdjustmentMagnitude": {
                return Optional.ofNullable(clazz.cast(this.minAdjustmentMagnitude()));
            }
            case "Cooldown": {
                return Optional.ofNullable(clazz.cast(this.cooldown()));
            }
            case "MetricAggregationType": {
                return Optional.ofNullable(clazz.cast(this.metricAggregationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StepScalingPolicyConfiguration, T> g) {
        return obj -> g.apply((StepScalingPolicyConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adjustmentType;
        private List<StepAdjustment> stepAdjustments = DefaultSdkAutoConstructList.getInstance();
        private Integer minAdjustmentMagnitude;
        private Integer cooldown;
        private String metricAggregationType;

        private BuilderImpl() {
        }

        private BuilderImpl(StepScalingPolicyConfiguration model) {
            this.adjustmentType(model.adjustmentType);
            this.stepAdjustments(model.stepAdjustments);
            this.minAdjustmentMagnitude(model.minAdjustmentMagnitude);
            this.cooldown(model.cooldown);
            this.metricAggregationType(model.metricAggregationType);
        }

        public final String getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        @Override
        public final Builder adjustmentType(AdjustmentType adjustmentType) {
            this.adjustmentType(adjustmentType == null ? null : adjustmentType.toString());
            return this;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        public final Collection<StepAdjustment.Builder> getStepAdjustments() {
            if (this.stepAdjustments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stepAdjustments != null ? (Collection)this.stepAdjustments.stream().map(StepAdjustment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copy(stepAdjustments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(StepAdjustment ... stepAdjustments) {
            this.stepAdjustments(Arrays.asList(stepAdjustments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(Consumer<StepAdjustment.Builder> ... stepAdjustments) {
            this.stepAdjustments(Stream.of(stepAdjustments).map(c -> (StepAdjustment)((StepAdjustment.Builder)StepAdjustment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStepAdjustments(Collection<StepAdjustment.BuilderImpl> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copyFromBuilder(stepAdjustments);
        }

        public final Integer getMinAdjustmentMagnitude() {
            return this.minAdjustmentMagnitude;
        }

        @Override
        public final Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        public final void setMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
        }

        public final Integer getCooldown() {
            return this.cooldown;
        }

        @Override
        public final Builder cooldown(Integer cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public final void setCooldown(Integer cooldown) {
            this.cooldown = cooldown;
        }

        public final String getMetricAggregationType() {
            return this.metricAggregationType;
        }

        @Override
        public final Builder metricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        @Override
        public final Builder metricAggregationType(MetricAggregationType metricAggregationType) {
            this.metricAggregationType(metricAggregationType == null ? null : metricAggregationType.toString());
            return this;
        }

        public final void setMetricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
        }

        public StepScalingPolicyConfiguration build() {
            return new StepScalingPolicyConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepScalingPolicyConfiguration> {
        public Builder adjustmentType(String var1);

        public Builder adjustmentType(AdjustmentType var1);

        public Builder stepAdjustments(Collection<StepAdjustment> var1);

        public Builder stepAdjustments(StepAdjustment ... var1);

        public Builder stepAdjustments(Consumer<StepAdjustment.Builder> ... var1);

        public Builder minAdjustmentMagnitude(Integer var1);

        public Builder cooldown(Integer var1);

        public Builder metricAggregationType(String var1);

        public Builder metricAggregationType(MetricAggregationType var1);
    }
}

