/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.AppSyncResponse;
import software.amazon.awssdk.services.appsync.model.SourceApiAssociationSummary;
import software.amazon.awssdk.services.appsync.model.SourceApiAssociationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSourceApiAssociationsResponse
extends AppSyncResponse
implements ToCopyableBuilder<Builder, ListSourceApiAssociationsResponse> {
    private static final SdkField<List<SourceApiAssociationSummary>> SOURCE_API_ASSOCIATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceApiAssociationSummaries").getter(ListSourceApiAssociationsResponse.getter(ListSourceApiAssociationsResponse::sourceApiAssociationSummaries)).setter(ListSourceApiAssociationsResponse.setter(Builder::sourceApiAssociationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceApiAssociationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceApiAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSourceApiAssociationsResponse.getter(ListSourceApiAssociationsResponse::nextToken)).setter(ListSourceApiAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_API_ASSOCIATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSourceApiAssociationsResponse.memberNameToFieldInitializer();
    private final List<SourceApiAssociationSummary> sourceApiAssociationSummaries;
    private final String nextToken;

    private ListSourceApiAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.sourceApiAssociationSummaries = builder.sourceApiAssociationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSourceApiAssociationSummaries() {
        return this.sourceApiAssociationSummaries != null && !(this.sourceApiAssociationSummaries instanceof SdkAutoConstructList);
    }

    public final List<SourceApiAssociationSummary> sourceApiAssociationSummaries() {
        return this.sourceApiAssociationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceApiAssociationSummaries() ? this.sourceApiAssociationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSourceApiAssociationsResponse)) {
            return false;
        }
        ListSourceApiAssociationsResponse other = (ListSourceApiAssociationsResponse)((Object)obj);
        return this.hasSourceApiAssociationSummaries() == other.hasSourceApiAssociationSummaries() && Objects.equals(this.sourceApiAssociationSummaries(), other.sourceApiAssociationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSourceApiAssociationsResponse").add("SourceApiAssociationSummaries", this.hasSourceApiAssociationSummaries() ? this.sourceApiAssociationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceApiAssociationSummaries": {
                return Optional.ofNullable(clazz.cast(this.sourceApiAssociationSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceApiAssociationSummaries", SOURCE_API_ASSOCIATION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSourceApiAssociationsResponse, T> g) {
        return obj -> g.apply((ListSourceApiAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncResponse.BuilderImpl
    implements Builder {
        private List<SourceApiAssociationSummary> sourceApiAssociationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSourceApiAssociationsResponse model) {
            super(model);
            this.sourceApiAssociationSummaries(model.sourceApiAssociationSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<SourceApiAssociationSummary.Builder> getSourceApiAssociationSummaries() {
            List<SourceApiAssociationSummary.Builder> result = SourceApiAssociationSummaryListCopier.copyToBuilder(this.sourceApiAssociationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceApiAssociationSummaries(Collection<SourceApiAssociationSummary.BuilderImpl> sourceApiAssociationSummaries) {
            this.sourceApiAssociationSummaries = SourceApiAssociationSummaryListCopier.copyFromBuilder(sourceApiAssociationSummaries);
        }

        @Override
        public final Builder sourceApiAssociationSummaries(Collection<SourceApiAssociationSummary> sourceApiAssociationSummaries) {
            this.sourceApiAssociationSummaries = SourceApiAssociationSummaryListCopier.copy(sourceApiAssociationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceApiAssociationSummaries(SourceApiAssociationSummary ... sourceApiAssociationSummaries) {
            this.sourceApiAssociationSummaries(Arrays.asList(sourceApiAssociationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceApiAssociationSummaries(Consumer<SourceApiAssociationSummary.Builder> ... sourceApiAssociationSummaries) {
            this.sourceApiAssociationSummaries(Stream.of(sourceApiAssociationSummaries).map(c -> (SourceApiAssociationSummary)((SourceApiAssociationSummary.Builder)SourceApiAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSourceApiAssociationsResponse build() {
            return new ListSourceApiAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSourceApiAssociationsResponse> {
        public Builder sourceApiAssociationSummaries(Collection<SourceApiAssociationSummary> var1);

        public Builder sourceApiAssociationSummaries(SourceApiAssociationSummary ... var1);

        public Builder sourceApiAssociationSummaries(Consumer<SourceApiAssociationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

