/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.FunctionConfiguration;
import software.amazon.awssdk.services.appsync.model.ListFunctionsRequest;
import software.amazon.awssdk.services.appsync.model.ListFunctionsResponse;

public class ListFunctionsIterable
implements SdkIterable<ListFunctionsResponse> {
    private final AppSyncClient client;
    private final ListFunctionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFunctionsIterable(AppSyncClient client, ListFunctionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFunctionsResponseFetcher();
    }

    public Iterator<ListFunctionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FunctionConfiguration> functions() {
        Function<ListFunctionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.functions() != null) {
                return response.functions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFunctionsResponseFetcher
    implements SyncPageFetcher<ListFunctionsResponse> {
        private ListFunctionsResponseFetcher() {
        }

        public boolean hasNextPage(ListFunctionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFunctionsResponse nextPage(ListFunctionsResponse previousPage) {
            if (previousPage == null) {
                return ListFunctionsIterable.this.client.listFunctions(ListFunctionsIterable.this.firstRequest);
            }
            return ListFunctionsIterable.this.client.listFunctions((ListFunctionsRequest)((Object)ListFunctionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

