/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.DataDeletionPolicy;
import software.amazon.awssdk.services.bedrockagent.model.DataSourceConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.DataSourceStatus;
import software.amazon.awssdk.services.bedrockagent.model.FailureReasonsCopier;
import software.amazon.awssdk.services.bedrockagent.model.ServerSideEncryptionConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.VectorIngestionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSource> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DataSource.getter(DataSource::createdAt)).setter(DataSource.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DATA_DELETION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataDeletionPolicy").getter(DataSource.getter(DataSource::dataDeletionPolicyAsString)).setter(DataSource.setter(Builder::dataDeletionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDeletionPolicy").build()}).build();
    private static final SdkField<DataSourceConfiguration> DATA_SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSourceConfiguration").getter(DataSource.getter(DataSource::dataSourceConfiguration)).setter(DataSource.setter(Builder::dataSourceConfiguration)).constructor(DataSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceConfiguration").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceId").getter(DataSource.getter(DataSource::dataSourceId)).setter(DataSource.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DataSource.getter(DataSource::description)).setter(DataSource.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(DataSource.getter(DataSource::failureReasons)).setter(DataSource.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(DataSource.getter(DataSource::knowledgeBaseId)).setter(DataSource.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DataSource.getter(DataSource::name)).setter(DataSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serverSideEncryptionConfiguration").getter(DataSource.getter(DataSource::serverSideEncryptionConfiguration)).setter(DataSource.setter(Builder::serverSideEncryptionConfiguration)).constructor(ServerSideEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverSideEncryptionConfiguration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DataSource.getter(DataSource::statusAsString)).setter(DataSource.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(DataSource.getter(DataSource::updatedAt)).setter(DataSource.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<VectorIngestionConfiguration> VECTOR_INGESTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vectorIngestionConfiguration").getter(DataSource.getter(DataSource::vectorIngestionConfiguration)).setter(DataSource.setter(Builder::vectorIngestionConfiguration)).constructor(VectorIngestionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorIngestionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DATA_DELETION_POLICY_FIELD, DATA_SOURCE_CONFIGURATION_FIELD, DATA_SOURCE_ID_FIELD, DESCRIPTION_FIELD, FAILURE_REASONS_FIELD, KNOWLEDGE_BASE_ID_FIELD, NAME_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, STATUS_FIELD, UPDATED_AT_FIELD, VECTOR_INGESTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String dataDeletionPolicy;
    private final DataSourceConfiguration dataSourceConfiguration;
    private final String dataSourceId;
    private final String description;
    private final List<String> failureReasons;
    private final String knowledgeBaseId;
    private final String name;
    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
    private final String status;
    private final Instant updatedAt;
    private final VectorIngestionConfiguration vectorIngestionConfiguration;

    private DataSource(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.dataDeletionPolicy = builder.dataDeletionPolicy;
        this.dataSourceConfiguration = builder.dataSourceConfiguration;
        this.dataSourceId = builder.dataSourceId;
        this.description = builder.description;
        this.failureReasons = builder.failureReasons;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.name = builder.name;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.vectorIngestionConfiguration = builder.vectorIngestionConfiguration;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final DataDeletionPolicy dataDeletionPolicy() {
        return DataDeletionPolicy.fromValue(this.dataDeletionPolicy);
    }

    public final String dataDeletionPolicyAsString() {
        return this.dataDeletionPolicy;
    }

    public final DataSourceConfiguration dataSourceConfiguration() {
        return this.dataSourceConfiguration;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String name() {
        return this.name;
    }

    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return this.serverSideEncryptionConfiguration;
    }

    public final DataSourceStatus status() {
        return DataSourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final VectorIngestionConfiguration vectorIngestionConfiguration() {
        return this.vectorIngestionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataDeletionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorIngestionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.dataDeletionPolicyAsString(), other.dataDeletionPolicyAsString()) && Objects.equals(this.dataSourceConfiguration(), other.dataSourceConfiguration()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.description(), other.description()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.vectorIngestionConfiguration(), other.vectorIngestionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DataSource").add("CreatedAt", (Object)this.createdAt()).add("DataDeletionPolicy", (Object)this.dataDeletionPolicyAsString()).add("DataSourceConfiguration", (Object)this.dataSourceConfiguration()).add("DataSourceId", (Object)this.dataSourceId()).add("Description", (Object)this.description()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Name", (Object)this.name()).add("ServerSideEncryptionConfiguration", (Object)this.serverSideEncryptionConfiguration()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).add("VectorIngestionConfiguration", (Object)this.vectorIngestionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "dataDeletionPolicy": {
                return Optional.ofNullable(clazz.cast(this.dataDeletionPolicyAsString()));
            }
            case "dataSourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataSourceConfiguration()));
            }
            case "dataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "serverSideEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverSideEncryptionConfiguration()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "vectorIngestionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vectorIngestionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("dataDeletionPolicy", DATA_DELETION_POLICY_FIELD);
        map.put("dataSourceConfiguration", DATA_SOURCE_CONFIGURATION_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("serverSideEncryptionConfiguration", SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("vectorIngestionConfiguration", VECTOR_INGESTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSource, T> g) {
        return obj -> g.apply((DataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String dataDeletionPolicy;
        private DataSourceConfiguration dataSourceConfiguration;
        private String dataSourceId;
        private String description;
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();
        private String knowledgeBaseId;
        private String name;
        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
        private String status;
        private Instant updatedAt;
        private VectorIngestionConfiguration vectorIngestionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSource model) {
            this.createdAt(model.createdAt);
            this.dataDeletionPolicy(model.dataDeletionPolicy);
            this.dataSourceConfiguration(model.dataSourceConfiguration);
            this.dataSourceId(model.dataSourceId);
            this.description(model.description);
            this.failureReasons(model.failureReasons);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.name(model.name);
            this.serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
            this.vectorIngestionConfiguration(model.vectorIngestionConfiguration);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDataDeletionPolicy() {
            return this.dataDeletionPolicy;
        }

        public final void setDataDeletionPolicy(String dataDeletionPolicy) {
            this.dataDeletionPolicy = dataDeletionPolicy;
        }

        @Override
        public final Builder dataDeletionPolicy(String dataDeletionPolicy) {
            this.dataDeletionPolicy = dataDeletionPolicy;
            return this;
        }

        @Override
        public final Builder dataDeletionPolicy(DataDeletionPolicy dataDeletionPolicy) {
            this.dataDeletionPolicy(dataDeletionPolicy == null ? null : dataDeletionPolicy.toString());
            return this;
        }

        public final DataSourceConfiguration.Builder getDataSourceConfiguration() {
            return this.dataSourceConfiguration != null ? this.dataSourceConfiguration.toBuilder() : null;
        }

        public final void setDataSourceConfiguration(DataSourceConfiguration.BuilderImpl dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration != null ? dataSourceConfiguration.build() : null;
        }

        @Override
        public final Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return this.serverSideEncryptionConfiguration != null ? this.serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final VectorIngestionConfiguration.Builder getVectorIngestionConfiguration() {
            return this.vectorIngestionConfiguration != null ? this.vectorIngestionConfiguration.toBuilder() : null;
        }

        public final void setVectorIngestionConfiguration(VectorIngestionConfiguration.BuilderImpl vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration != null ? vectorIngestionConfiguration.build() : null;
        }

        @Override
        public final Builder vectorIngestionConfiguration(VectorIngestionConfiguration vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration;
            return this;
        }

        public DataSource build() {
            return new DataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSource> {
        public Builder createdAt(Instant var1);

        public Builder dataDeletionPolicy(String var1);

        public Builder dataDeletionPolicy(DataDeletionPolicy var1);

        public Builder dataSourceConfiguration(DataSourceConfiguration var1);

        default public Builder dataSourceConfiguration(Consumer<DataSourceConfiguration.Builder> dataSourceConfiguration) {
            return this.dataSourceConfiguration((DataSourceConfiguration)((DataSourceConfiguration.Builder)DataSourceConfiguration.builder().applyMutation(dataSourceConfiguration)).build());
        }

        public Builder dataSourceId(String var1);

        public Builder description(String var1);

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);

        public Builder knowledgeBaseId(String var1);

        public Builder name(String var1);

        public Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration var1);

        default public Builder serverSideEncryptionConfiguration(Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return this.serverSideEncryptionConfiguration((ServerSideEncryptionConfiguration)((ServerSideEncryptionConfiguration.Builder)ServerSideEncryptionConfiguration.builder().applyMutation(serverSideEncryptionConfiguration)).build());
        }

        public Builder status(String var1);

        public Builder status(DataSourceStatus var1);

        public Builder updatedAt(Instant var1);

        public Builder vectorIngestionConfiguration(VectorIngestionConfiguration var1);

        default public Builder vectorIngestionConfiguration(Consumer<VectorIngestionConfiguration.Builder> vectorIngestionConfiguration) {
            return this.vectorIngestionConfiguration((VectorIngestionConfiguration)((VectorIngestionConfiguration.Builder)VectorIngestionConfiguration.builder().applyMutation(vectorIngestionConfiguration)).build());
        }
    }
}

