/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceClient;
import software.amazon.awssdk.services.chimesdkvoice.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsResponse;

public class ListVoiceProfileDomainsIterable
implements SdkIterable<ListVoiceProfileDomainsResponse> {
    private final ChimeSdkVoiceClient client;
    private final ListVoiceProfileDomainsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVoiceProfileDomainsIterable(ChimeSdkVoiceClient client, ListVoiceProfileDomainsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVoiceProfileDomainsResponseFetcher();
    }

    public Iterator<ListVoiceProfileDomainsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListVoiceProfileDomainsResponseFetcher
    implements SyncPageFetcher<ListVoiceProfileDomainsResponse> {
        private ListVoiceProfileDomainsResponseFetcher() {
        }

        public boolean hasNextPage(ListVoiceProfileDomainsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVoiceProfileDomainsResponse nextPage(ListVoiceProfileDomainsResponse previousPage) {
            if (previousPage == null) {
                return ListVoiceProfileDomainsIterable.this.client.listVoiceProfileDomains(ListVoiceProfileDomainsIterable.this.firstRequest);
            }
            return ListVoiceProfileDomainsIterable.this.client.listVoiceProfileDomains((ListVoiceProfileDomainsRequest)((Object)ListVoiceProfileDomainsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

