/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.ReportFilter;
import software.amazon.awssdk.services.codebuild.model.SortOrderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReportsForReportGroupRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, ListReportsForReportGroupRequest> {
    private static final SdkField<String> REPORT_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportGroupArn").getter(ListReportsForReportGroupRequest.getter(ListReportsForReportGroupRequest::reportGroupArn)).setter(ListReportsForReportGroupRequest.setter(Builder::reportGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportGroupArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListReportsForReportGroupRequest.getter(ListReportsForReportGroupRequest::nextToken)).setter(ListReportsForReportGroupRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(ListReportsForReportGroupRequest.getter(ListReportsForReportGroupRequest::sortOrderAsString)).setter(ListReportsForReportGroupRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListReportsForReportGroupRequest.getter(ListReportsForReportGroupRequest::maxResults)).setter(ListReportsForReportGroupRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<ReportFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filter").getter(ListReportsForReportGroupRequest.getter(ListReportsForReportGroupRequest::filter)).setter(ListReportsForReportGroupRequest.setter(Builder::filter)).constructor(ReportFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GROUP_ARN_FIELD, NEXT_TOKEN_FIELD, SORT_ORDER_FIELD, MAX_RESULTS_FIELD, FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReportsForReportGroupRequest.memberNameToFieldInitializer();
    private final String reportGroupArn;
    private final String nextToken;
    private final String sortOrder;
    private final Integer maxResults;
    private final ReportFilter filter;

    private ListReportsForReportGroupRequest(BuilderImpl builder) {
        super(builder);
        this.reportGroupArn = builder.reportGroupArn;
        this.nextToken = builder.nextToken;
        this.sortOrder = builder.sortOrder;
        this.maxResults = builder.maxResults;
        this.filter = builder.filter;
    }

    public final String reportGroupArn() {
        return this.reportGroupArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final SortOrderType sortOrder() {
        return SortOrderType.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ReportFilter filter() {
        return this.filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportsForReportGroupRequest)) {
            return false;
        }
        ListReportsForReportGroupRequest other = (ListReportsForReportGroupRequest)((Object)obj);
        return Objects.equals(this.reportGroupArn(), other.reportGroupArn()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.filter(), other.filter());
    }

    public final String toString() {
        return ToString.builder((String)"ListReportsForReportGroupRequest").add("ReportGroupArn", (Object)this.reportGroupArn()).add("NextToken", (Object)this.nextToken()).add("SortOrder", (Object)this.sortOrderAsString()).add("MaxResults", (Object)this.maxResults()).add("Filter", (Object)this.filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportGroupArn": {
                return Optional.ofNullable(clazz.cast(this.reportGroupArn()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reportGroupArn", REPORT_GROUP_ARN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReportsForReportGroupRequest, T> g) {
        return obj -> g.apply((ListReportsForReportGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String reportGroupArn;
        private String nextToken;
        private String sortOrder;
        private Integer maxResults;
        private ReportFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReportsForReportGroupRequest model) {
            super(model);
            this.reportGroupArn(model.reportGroupArn);
            this.nextToken(model.nextToken);
            this.sortOrder(model.sortOrder);
            this.maxResults(model.maxResults);
            this.filter(model.filter);
        }

        public final String getReportGroupArn() {
            return this.reportGroupArn;
        }

        public final void setReportGroupArn(String reportGroupArn) {
            this.reportGroupArn = reportGroupArn;
        }

        @Override
        public final Builder reportGroupArn(String reportGroupArn) {
            this.reportGroupArn = reportGroupArn;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrderType sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final ReportFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(ReportFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(ReportFilter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReportsForReportGroupRequest build() {
            return new ListReportsForReportGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReportsForReportGroupRequest> {
        public Builder reportGroupArn(String var1);

        public Builder nextToken(String var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrderType var1);

        public Builder maxResults(Integer var1);

        public Builder filter(ReportFilter var1);

        default public Builder filter(Consumer<ReportFilter.Builder> filter) {
            return this.filter((ReportFilter)((ReportFilter.Builder)ReportFilter.builder().applyMutation(filter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

