/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.FleetScalingMetricType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetTrackingScalingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetTrackingScalingConfiguration> {
    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricType").getter(TargetTrackingScalingConfiguration.getter(TargetTrackingScalingConfiguration::metricTypeAsString)).setter(TargetTrackingScalingConfiguration.setter(Builder::metricType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricType").build()}).build();
    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("targetValue").getter(TargetTrackingScalingConfiguration.getter(TargetTrackingScalingConfiguration::targetValue)).setter(TargetTrackingScalingConfiguration.setter(Builder::targetValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_TYPE_FIELD, TARGET_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TargetTrackingScalingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metricType;
    private final Double targetValue;

    private TargetTrackingScalingConfiguration(BuilderImpl builder) {
        this.metricType = builder.metricType;
        this.targetValue = builder.targetValue;
    }

    public final FleetScalingMetricType metricType() {
        return FleetScalingMetricType.fromValue(this.metricType);
    }

    public final String metricTypeAsString() {
        return this.metricType;
    }

    public final Double targetValue() {
        return this.targetValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingScalingConfiguration)) {
            return false;
        }
        TargetTrackingScalingConfiguration other = (TargetTrackingScalingConfiguration)obj;
        return Objects.equals(this.metricTypeAsString(), other.metricTypeAsString()) && Objects.equals(this.targetValue(), other.targetValue());
    }

    public final String toString() {
        return ToString.builder((String)"TargetTrackingScalingConfiguration").add("MetricType", (Object)this.metricTypeAsString()).add("TargetValue", (Object)this.targetValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricType": {
                return Optional.ofNullable(clazz.cast(this.metricTypeAsString()));
            }
            case "targetValue": {
                return Optional.ofNullable(clazz.cast(this.targetValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("metricType", METRIC_TYPE_FIELD);
        map.put("targetValue", TARGET_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingScalingConfiguration, T> g) {
        return obj -> g.apply((TargetTrackingScalingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricType;
        private Double targetValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingScalingConfiguration model) {
            this.metricType(model.metricType);
            this.targetValue(model.targetValue);
        }

        public final String getMetricType() {
            return this.metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(FleetScalingMetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final Double getTargetValue() {
            return this.targetValue;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public TargetTrackingScalingConfiguration build() {
            return new TargetTrackingScalingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetTrackingScalingConfiguration> {
        public Builder metricType(String var1);

        public Builder metricType(FleetScalingMetricType var1);

        public Builder targetValue(Double var1);
    }
}

