/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OrderEnum {
    ASCENDING("ascending"),
    DESCENDING("descending"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OrderEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OrderEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OrderEnum.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OrderEnum> knownValues() {
        return Stream.of(OrderEnum.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

