/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcontactlens.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcontactlens.model.IssueDetected;
import software.amazon.awssdk.services.connectcontactlens.model.IssuesDetectedCopier;
import software.amazon.awssdk.services.connectcontactlens.model.SentimentValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Transcript
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Transcript> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Transcript.getter(Transcript::id)).setter(Transcript.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantId").getter(Transcript.getter(Transcript::participantId)).setter(Transcript.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()}).build();
    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantRole").getter(Transcript.getter(Transcript::participantRole)).setter(Transcript.setter(Builder::participantRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(Transcript.getter(Transcript::content)).setter(Transcript.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<Integer> BEGIN_OFFSET_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BeginOffsetMillis").getter(Transcript.getter(Transcript::beginOffsetMillis)).setter(Transcript.setter(Builder::beginOffsetMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffsetMillis").build()}).build();
    private static final SdkField<Integer> END_OFFSET_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndOffsetMillis").getter(Transcript.getter(Transcript::endOffsetMillis)).setter(Transcript.setter(Builder::endOffsetMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffsetMillis").build()}).build();
    private static final SdkField<String> SENTIMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sentiment").getter(Transcript.getter(Transcript::sentimentAsString)).setter(Transcript.setter(Builder::sentiment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sentiment").build()}).build();
    private static final SdkField<List<IssueDetected>> ISSUES_DETECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IssuesDetected").getter(Transcript.getter(Transcript::issuesDetected)).setter(Transcript.setter(Builder::issuesDetected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuesDetected").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IssueDetected::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PARTICIPANT_ID_FIELD, PARTICIPANT_ROLE_FIELD, CONTENT_FIELD, BEGIN_OFFSET_MILLIS_FIELD, END_OFFSET_MILLIS_FIELD, SENTIMENT_FIELD, ISSUES_DETECTED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String participantId;
    private final String participantRole;
    private final String content;
    private final Integer beginOffsetMillis;
    private final Integer endOffsetMillis;
    private final String sentiment;
    private final List<IssueDetected> issuesDetected;

    private Transcript(BuilderImpl builder) {
        this.id = builder.id;
        this.participantId = builder.participantId;
        this.participantRole = builder.participantRole;
        this.content = builder.content;
        this.beginOffsetMillis = builder.beginOffsetMillis;
        this.endOffsetMillis = builder.endOffsetMillis;
        this.sentiment = builder.sentiment;
        this.issuesDetected = builder.issuesDetected;
    }

    public final String id() {
        return this.id;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final String participantRole() {
        return this.participantRole;
    }

    public final String content() {
        return this.content;
    }

    public final Integer beginOffsetMillis() {
        return this.beginOffsetMillis;
    }

    public final Integer endOffsetMillis() {
        return this.endOffsetMillis;
    }

    public final SentimentValue sentiment() {
        return SentimentValue.fromValue(this.sentiment);
    }

    public final String sentimentAsString() {
        return this.sentiment;
    }

    public final boolean hasIssuesDetected() {
        return this.issuesDetected != null && !(this.issuesDetected instanceof SdkAutoConstructList);
    }

    public final List<IssueDetected> issuesDetected() {
        return this.issuesDetected;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIssuesDetected() ? this.issuesDetected() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transcript)) {
            return false;
        }
        Transcript other = (Transcript)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.participantRole(), other.participantRole()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.beginOffsetMillis(), other.beginOffsetMillis()) && Objects.equals(this.endOffsetMillis(), other.endOffsetMillis()) && Objects.equals(this.sentimentAsString(), other.sentimentAsString()) && this.hasIssuesDetected() == other.hasIssuesDetected() && Objects.equals(this.issuesDetected(), other.issuesDetected());
    }

    public final String toString() {
        return ToString.builder((String)"Transcript").add("Id", (Object)this.id()).add("ParticipantId", (Object)this.participantId()).add("ParticipantRole", (Object)this.participantRole()).add("Content", (Object)this.content()).add("BeginOffsetMillis", (Object)this.beginOffsetMillis()).add("EndOffsetMillis", (Object)this.endOffsetMillis()).add("Sentiment", (Object)this.sentimentAsString()).add("IssuesDetected", this.hasIssuesDetected() ? this.issuesDetected() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ParticipantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "ParticipantRole": {
                return Optional.ofNullable(clazz.cast(this.participantRole()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "BeginOffsetMillis": {
                return Optional.ofNullable(clazz.cast(this.beginOffsetMillis()));
            }
            case "EndOffsetMillis": {
                return Optional.ofNullable(clazz.cast(this.endOffsetMillis()));
            }
            case "Sentiment": {
                return Optional.ofNullable(clazz.cast(this.sentimentAsString()));
            }
            case "IssuesDetected": {
                return Optional.ofNullable(clazz.cast(this.issuesDetected()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Transcript, T> g) {
        return obj -> g.apply((Transcript)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String participantId;
        private String participantRole;
        private String content;
        private Integer beginOffsetMillis;
        private Integer endOffsetMillis;
        private String sentiment;
        private List<IssueDetected> issuesDetected = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Transcript model) {
            this.id(model.id);
            this.participantId(model.participantId);
            this.participantRole(model.participantRole);
            this.content(model.content);
            this.beginOffsetMillis(model.beginOffsetMillis);
            this.endOffsetMillis(model.endOffsetMillis);
            this.sentiment(model.sentiment);
            this.issuesDetected(model.issuesDetected);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        public final String getParticipantRole() {
            return this.participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final Integer getBeginOffsetMillis() {
            return this.beginOffsetMillis;
        }

        @Override
        public final Builder beginOffsetMillis(Integer beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
            return this;
        }

        public final void setBeginOffsetMillis(Integer beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
        }

        public final Integer getEndOffsetMillis() {
            return this.endOffsetMillis;
        }

        @Override
        public final Builder endOffsetMillis(Integer endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
            return this;
        }

        public final void setEndOffsetMillis(Integer endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
        }

        public final String getSentiment() {
            return this.sentiment;
        }

        @Override
        public final Builder sentiment(String sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        public final Builder sentiment(SentimentValue sentiment) {
            this.sentiment(sentiment == null ? null : sentiment.toString());
            return this;
        }

        public final void setSentiment(String sentiment) {
            this.sentiment = sentiment;
        }

        public final Collection<IssueDetected.Builder> getIssuesDetected() {
            if (this.issuesDetected instanceof SdkAutoConstructList) {
                return null;
            }
            return this.issuesDetected != null ? (Collection)this.issuesDetected.stream().map(IssueDetected::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder issuesDetected(Collection<IssueDetected> issuesDetected) {
            this.issuesDetected = IssuesDetectedCopier.copy(issuesDetected);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issuesDetected(IssueDetected ... issuesDetected) {
            this.issuesDetected(Arrays.asList(issuesDetected));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issuesDetected(Consumer<IssueDetected.Builder> ... issuesDetected) {
            this.issuesDetected(Stream.of(issuesDetected).map(c -> (IssueDetected)((IssueDetected.Builder)IssueDetected.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIssuesDetected(Collection<IssueDetected.BuilderImpl> issuesDetected) {
            this.issuesDetected = IssuesDetectedCopier.copyFromBuilder(issuesDetected);
        }

        public Transcript build() {
            return new Transcript(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Transcript> {
        public Builder id(String var1);

        public Builder participantId(String var1);

        public Builder participantRole(String var1);

        public Builder content(String var1);

        public Builder beginOffsetMillis(Integer var1);

        public Builder endOffsetMillis(Integer var1);

        public Builder sentiment(String var1);

        public Builder sentiment(SentimentValue var1);

        public Builder issuesDetected(Collection<IssueDetected> var1);

        public Builder issuesDetected(IssueDetected ... var1);

        public Builder issuesDetected(Consumer<IssueDetected.Builder> ... var1);
    }
}

