/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeRequest;
import software.amazon.awssdk.services.dataexchange.model.NotificationDetails;
import software.amazon.awssdk.services.dataexchange.model.NotificationType;
import software.amazon.awssdk.services.dataexchange.model.ScopeDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendDataSetNotificationRequest
extends DataExchangeRequest
implements ToCopyableBuilder<Builder, SendDataSetNotificationRequest> {
    private static final SdkField<ScopeDetails> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Scope").getter(SendDataSetNotificationRequest.getter(SendDataSetNotificationRequest::scope)).setter(SendDataSetNotificationRequest.setter(Builder::scope)).constructor(ScopeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(SendDataSetNotificationRequest.getter(SendDataSetNotificationRequest::clientToken)).setter(SendDataSetNotificationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(SendDataSetNotificationRequest.getter(SendDataSetNotificationRequest::comment)).setter(SendDataSetNotificationRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(SendDataSetNotificationRequest.getter(SendDataSetNotificationRequest::dataSetId)).setter(SendDataSetNotificationRequest.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSetId").build()}).build();
    private static final SdkField<NotificationDetails> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Details").getter(SendDataSetNotificationRequest.getter(SendDataSetNotificationRequest::details)).setter(SendDataSetNotificationRequest.setter(Builder::details)).constructor(NotificationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SendDataSetNotificationRequest.getter(SendDataSetNotificationRequest::typeAsString)).setter(SendDataSetNotificationRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD, CLIENT_TOKEN_FIELD, COMMENT_FIELD, DATA_SET_ID_FIELD, DETAILS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendDataSetNotificationRequest.memberNameToFieldInitializer();
    private final ScopeDetails scope;
    private final String clientToken;
    private final String comment;
    private final String dataSetId;
    private final NotificationDetails details;
    private final String type;

    private SendDataSetNotificationRequest(BuilderImpl builder) {
        super(builder);
        this.scope = builder.scope;
        this.clientToken = builder.clientToken;
        this.comment = builder.comment;
        this.dataSetId = builder.dataSetId;
        this.details = builder.details;
        this.type = builder.type;
    }

    public final ScopeDetails scope() {
        return this.scope;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String comment() {
        return this.comment;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final NotificationDetails details() {
        return this.details;
    }

    public final NotificationType type() {
        return NotificationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDataSetNotificationRequest)) {
            return false;
        }
        SendDataSetNotificationRequest other = (SendDataSetNotificationRequest)((Object)obj);
        return Objects.equals(this.scope(), other.scope()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.details(), other.details()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SendDataSetNotificationRequest").add("Scope", (Object)this.scope()).add("ClientToken", (Object)this.clientToken()).add("Comment", (Object)this.comment()).add("DataSetId", (Object)this.dataSetId()).add("Details", (Object)this.details()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Scope", SCOPE_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Comment", COMMENT_FIELD);
        map.put("DataSetId", DATA_SET_ID_FIELD);
        map.put("Details", DETAILS_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendDataSetNotificationRequest, T> g) {
        return obj -> g.apply((SendDataSetNotificationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeRequest.BuilderImpl
    implements Builder {
        private ScopeDetails scope;
        private String clientToken;
        private String comment;
        private String dataSetId;
        private NotificationDetails details;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SendDataSetNotificationRequest model) {
            super(model);
            this.scope(model.scope);
            this.clientToken(model.clientToken);
            this.comment(model.comment);
            this.dataSetId(model.dataSetId);
            this.details(model.details);
            this.type(model.type);
        }

        public final ScopeDetails.Builder getScope() {
            return this.scope != null ? this.scope.toBuilder() : null;
        }

        public final void setScope(ScopeDetails.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(ScopeDetails scope) {
            this.scope = scope;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final NotificationDetails.Builder getDetails() {
            return this.details != null ? this.details.toBuilder() : null;
        }

        public final void setDetails(NotificationDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(NotificationDetails details) {
            this.details = details;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NotificationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendDataSetNotificationRequest build() {
            return new SendDataSetNotificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataExchangeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendDataSetNotificationRequest> {
        public Builder scope(ScopeDetails var1);

        default public Builder scope(Consumer<ScopeDetails.Builder> scope) {
            return this.scope((ScopeDetails)((ScopeDetails.Builder)ScopeDetails.builder().applyMutation(scope)).build());
        }

        public Builder clientToken(String var1);

        public Builder comment(String var1);

        public Builder dataSetId(String var1);

        public Builder details(NotificationDetails var1);

        default public Builder details(Consumer<NotificationDetails.Builder> details) {
            return this.details((NotificationDetails)((NotificationDetails.Builder)NotificationDetails.builder().applyMutation(details)).build());
        }

        public Builder type(String var1);

        public Builder type(NotificationType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

