/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationParameter;
import software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationParametersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentConfigurationParametersDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentConfigurationParametersDetails> {
    private static final SdkField<List<EnvironmentConfigurationParameter>> PARAMETER_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameterOverrides").getter(EnvironmentConfigurationParametersDetails.getter(EnvironmentConfigurationParametersDetails::parameterOverrides)).setter(EnvironmentConfigurationParametersDetails.setter(Builder::parameterOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentConfigurationParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EnvironmentConfigurationParameter>> RESOLVED_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resolvedParameters").getter(EnvironmentConfigurationParametersDetails.getter(EnvironmentConfigurationParametersDetails::resolvedParameters)).setter(EnvironmentConfigurationParametersDetails.setter(Builder::resolvedParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentConfigurationParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SSM_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ssmPath").getter(EnvironmentConfigurationParametersDetails.getter(EnvironmentConfigurationParametersDetails::ssmPath)).setter(EnvironmentConfigurationParametersDetails.setter(Builder::ssmPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_OVERRIDES_FIELD, RESOLVED_PARAMETERS_FIELD, SSM_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnvironmentConfigurationParametersDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<EnvironmentConfigurationParameter> parameterOverrides;
    private final List<EnvironmentConfigurationParameter> resolvedParameters;
    private final String ssmPath;

    private EnvironmentConfigurationParametersDetails(BuilderImpl builder) {
        this.parameterOverrides = builder.parameterOverrides;
        this.resolvedParameters = builder.resolvedParameters;
        this.ssmPath = builder.ssmPath;
    }

    public final boolean hasParameterOverrides() {
        return this.parameterOverrides != null && !(this.parameterOverrides instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentConfigurationParameter> parameterOverrides() {
        return this.parameterOverrides;
    }

    public final boolean hasResolvedParameters() {
        return this.resolvedParameters != null && !(this.resolvedParameters instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentConfigurationParameter> resolvedParameters() {
        return this.resolvedParameters;
    }

    public final String ssmPath() {
        return this.ssmPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterOverrides() ? this.parameterOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResolvedParameters() ? this.resolvedParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ssmPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentConfigurationParametersDetails)) {
            return false;
        }
        EnvironmentConfigurationParametersDetails other = (EnvironmentConfigurationParametersDetails)obj;
        return this.hasParameterOverrides() == other.hasParameterOverrides() && Objects.equals(this.parameterOverrides(), other.parameterOverrides()) && this.hasResolvedParameters() == other.hasResolvedParameters() && Objects.equals(this.resolvedParameters(), other.resolvedParameters()) && Objects.equals(this.ssmPath(), other.ssmPath());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentConfigurationParametersDetails").add("ParameterOverrides", this.hasParameterOverrides() ? this.parameterOverrides() : null).add("ResolvedParameters", this.hasResolvedParameters() ? this.resolvedParameters() : null).add("SsmPath", (Object)this.ssmPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "parameterOverrides": {
                return Optional.ofNullable(clazz.cast(this.parameterOverrides()));
            }
            case "resolvedParameters": {
                return Optional.ofNullable(clazz.cast(this.resolvedParameters()));
            }
            case "ssmPath": {
                return Optional.ofNullable(clazz.cast(this.ssmPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("parameterOverrides", PARAMETER_OVERRIDES_FIELD);
        map.put("resolvedParameters", RESOLVED_PARAMETERS_FIELD);
        map.put("ssmPath", SSM_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentConfigurationParametersDetails, T> g) {
        return obj -> g.apply((EnvironmentConfigurationParametersDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EnvironmentConfigurationParameter> parameterOverrides = DefaultSdkAutoConstructList.getInstance();
        private List<EnvironmentConfigurationParameter> resolvedParameters = DefaultSdkAutoConstructList.getInstance();
        private String ssmPath;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentConfigurationParametersDetails model) {
            this.parameterOverrides(model.parameterOverrides);
            this.resolvedParameters(model.resolvedParameters);
            this.ssmPath(model.ssmPath);
        }

        public final List<EnvironmentConfigurationParameter.Builder> getParameterOverrides() {
            List<EnvironmentConfigurationParameter.Builder> result = EnvironmentConfigurationParametersListCopier.copyToBuilder(this.parameterOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterOverrides(Collection<EnvironmentConfigurationParameter.BuilderImpl> parameterOverrides) {
            this.parameterOverrides = EnvironmentConfigurationParametersListCopier.copyFromBuilder(parameterOverrides);
        }

        @Override
        public final Builder parameterOverrides(Collection<EnvironmentConfigurationParameter> parameterOverrides) {
            this.parameterOverrides = EnvironmentConfigurationParametersListCopier.copy(parameterOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(EnvironmentConfigurationParameter ... parameterOverrides) {
            this.parameterOverrides(Arrays.asList(parameterOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(Consumer<EnvironmentConfigurationParameter.Builder> ... parameterOverrides) {
            this.parameterOverrides(Stream.of(parameterOverrides).map(c -> (EnvironmentConfigurationParameter)((EnvironmentConfigurationParameter.Builder)EnvironmentConfigurationParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EnvironmentConfigurationParameter.Builder> getResolvedParameters() {
            List<EnvironmentConfigurationParameter.Builder> result = EnvironmentConfigurationParametersListCopier.copyToBuilder(this.resolvedParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResolvedParameters(Collection<EnvironmentConfigurationParameter.BuilderImpl> resolvedParameters) {
            this.resolvedParameters = EnvironmentConfigurationParametersListCopier.copyFromBuilder(resolvedParameters);
        }

        @Override
        public final Builder resolvedParameters(Collection<EnvironmentConfigurationParameter> resolvedParameters) {
            this.resolvedParameters = EnvironmentConfigurationParametersListCopier.copy(resolvedParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolvedParameters(EnvironmentConfigurationParameter ... resolvedParameters) {
            this.resolvedParameters(Arrays.asList(resolvedParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolvedParameters(Consumer<EnvironmentConfigurationParameter.Builder> ... resolvedParameters) {
            this.resolvedParameters(Stream.of(resolvedParameters).map(c -> (EnvironmentConfigurationParameter)((EnvironmentConfigurationParameter.Builder)EnvironmentConfigurationParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSsmPath() {
            return this.ssmPath;
        }

        public final void setSsmPath(String ssmPath) {
            this.ssmPath = ssmPath;
        }

        @Override
        public final Builder ssmPath(String ssmPath) {
            this.ssmPath = ssmPath;
            return this;
        }

        public EnvironmentConfigurationParametersDetails build() {
            return new EnvironmentConfigurationParametersDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentConfigurationParametersDetails> {
        public Builder parameterOverrides(Collection<EnvironmentConfigurationParameter> var1);

        public Builder parameterOverrides(EnvironmentConfigurationParameter ... var1);

        public Builder parameterOverrides(Consumer<EnvironmentConfigurationParameter.Builder> ... var1);

        public Builder resolvedParameters(Collection<EnvironmentConfigurationParameter> var1);

        public Builder resolvedParameters(EnvironmentConfigurationParameter ... var1);

        public Builder resolvedParameters(Consumer<EnvironmentConfigurationParameter.Builder> ... var1);

        public Builder ssmPath(String var1);
    }
}

