/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UserProfileStatus {
    ASSIGNED("ASSIGNED"),
    NOT_ASSIGNED("NOT_ASSIGNED"),
    ACTIVATED("ACTIVATED"),
    DEACTIVATED("DEACTIVATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UserProfileStatus> VALUE_MAP;
    private final String value;

    private UserProfileStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UserProfileStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UserProfileStatus> knownValues() {
        EnumSet<UserProfileStatus> knownValues = EnumSet.allOf(UserProfileStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UserProfileStatus.class, UserProfileStatus::toString);
    }
}

