/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.EnvironmentActionSummary;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsResponse;

public class ListEnvironmentActionsPublisher
implements SdkPublisher<ListEnvironmentActionsResponse> {
    private final DataZoneAsyncClient client;
    private final ListEnvironmentActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnvironmentActionsPublisher(DataZoneAsyncClient client, ListEnvironmentActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnvironmentActionsPublisher(DataZoneAsyncClient client, ListEnvironmentActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnvironmentActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnvironmentActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EnvironmentActionSummary> items() {
        Function<ListEnvironmentActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnvironmentActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnvironmentActionsResponseFetcher
    implements AsyncPageFetcher<ListEnvironmentActionsResponse> {
        private ListEnvironmentActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnvironmentActionsResponse> nextPage(ListEnvironmentActionsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentActionsPublisher.this.client.listEnvironmentActions(ListEnvironmentActionsPublisher.this.firstRequest);
            }
            return ListEnvironmentActionsPublisher.this.client.listEnvironmentActions((ListEnvironmentActionsRequest)((Object)ListEnvironmentActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

