/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryDescription;
import software.amazon.awssdk.services.directory.model.DirectoryDescriptionsCopier;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDirectoriesResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeDirectoriesResponse> {
    private static final SdkField<List<DirectoryDescription>> DIRECTORY_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DirectoryDescriptions").getter(DescribeDirectoriesResponse.getter(DescribeDirectoriesResponse::directoryDescriptions)).setter(DescribeDirectoriesResponse.setter(Builder::directoryDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DirectoryDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeDirectoriesResponse.getter(DescribeDirectoriesResponse::nextToken)).setter(DescribeDirectoriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_DESCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDirectoriesResponse.memberNameToFieldInitializer();
    private final List<DirectoryDescription> directoryDescriptions;
    private final String nextToken;

    private DescribeDirectoriesResponse(BuilderImpl builder) {
        super(builder);
        this.directoryDescriptions = builder.directoryDescriptions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDirectoryDescriptions() {
        return this.directoryDescriptions != null && !(this.directoryDescriptions instanceof SdkAutoConstructList);
    }

    public final List<DirectoryDescription> directoryDescriptions() {
        return this.directoryDescriptions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDirectoryDescriptions() ? this.directoryDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectoriesResponse)) {
            return false;
        }
        DescribeDirectoriesResponse other = (DescribeDirectoriesResponse)((Object)obj);
        return this.hasDirectoryDescriptions() == other.hasDirectoryDescriptions() && Objects.equals(this.directoryDescriptions(), other.directoryDescriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDirectoriesResponse").add("DirectoryDescriptions", this.hasDirectoryDescriptions() ? this.directoryDescriptions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryDescriptions": {
                return Optional.ofNullable(clazz.cast(this.directoryDescriptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryDescriptions", DIRECTORY_DESCRIPTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectoriesResponse, T> g) {
        return obj -> g.apply((DescribeDirectoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private List<DirectoryDescription> directoryDescriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectoriesResponse model) {
            super(model);
            this.directoryDescriptions(model.directoryDescriptions);
            this.nextToken(model.nextToken);
        }

        public final List<DirectoryDescription.Builder> getDirectoryDescriptions() {
            List<DirectoryDescription.Builder> result = DirectoryDescriptionsCopier.copyToBuilder(this.directoryDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDirectoryDescriptions(Collection<DirectoryDescription.BuilderImpl> directoryDescriptions) {
            this.directoryDescriptions = DirectoryDescriptionsCopier.copyFromBuilder(directoryDescriptions);
        }

        @Override
        public final Builder directoryDescriptions(Collection<DirectoryDescription> directoryDescriptions) {
            this.directoryDescriptions = DirectoryDescriptionsCopier.copy(directoryDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryDescriptions(DirectoryDescription ... directoryDescriptions) {
            this.directoryDescriptions(Arrays.asList(directoryDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryDescriptions(Consumer<DirectoryDescription.Builder> ... directoryDescriptions) {
            this.directoryDescriptions(Stream.of(directoryDescriptions).map(c -> (DirectoryDescription)((DirectoryDescription.Builder)DirectoryDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDirectoriesResponse build() {
            return new DescribeDirectoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDirectoriesResponse> {
        public Builder directoryDescriptions(Collection<DirectoryDescription> var1);

        public Builder directoryDescriptions(DirectoryDescription ... var1);

        public Builder directoryDescriptions(Consumer<DirectoryDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

