/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.model.OSUpdateSettings;
import software.amazon.awssdk.services.directory.model.UpdateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDirectorySetupRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, UpdateDirectorySetupRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(UpdateDirectorySetupRequest.getter(UpdateDirectorySetupRequest::directoryId)).setter(UpdateDirectorySetupRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateType").getter(UpdateDirectorySetupRequest.getter(UpdateDirectorySetupRequest::updateTypeAsString)).setter(UpdateDirectorySetupRequest.setter(Builder::updateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateType").build()}).build();
    private static final SdkField<OSUpdateSettings> OS_UPDATE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OSUpdateSettings").getter(UpdateDirectorySetupRequest.getter(UpdateDirectorySetupRequest::osUpdateSettings)).setter(UpdateDirectorySetupRequest.setter(Builder::osUpdateSettings)).constructor(OSUpdateSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OSUpdateSettings").build()}).build();
    private static final SdkField<Boolean> CREATE_SNAPSHOT_BEFORE_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CreateSnapshotBeforeUpdate").getter(UpdateDirectorySetupRequest.getter(UpdateDirectorySetupRequest::createSnapshotBeforeUpdate)).setter(UpdateDirectorySetupRequest.setter(Builder::createSnapshotBeforeUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateSnapshotBeforeUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, UPDATE_TYPE_FIELD, OS_UPDATE_SETTINGS_FIELD, CREATE_SNAPSHOT_BEFORE_UPDATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDirectorySetupRequest.memberNameToFieldInitializer();
    private final String directoryId;
    private final String updateType;
    private final OSUpdateSettings osUpdateSettings;
    private final Boolean createSnapshotBeforeUpdate;

    private UpdateDirectorySetupRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.updateType = builder.updateType;
        this.osUpdateSettings = builder.osUpdateSettings;
        this.createSnapshotBeforeUpdate = builder.createSnapshotBeforeUpdate;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final UpdateType updateType() {
        return UpdateType.fromValue(this.updateType);
    }

    public final String updateTypeAsString() {
        return this.updateType;
    }

    public final OSUpdateSettings osUpdateSettings() {
        return this.osUpdateSettings;
    }

    public final Boolean createSnapshotBeforeUpdate() {
        return this.createSnapshotBeforeUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.osUpdateSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.createSnapshotBeforeUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDirectorySetupRequest)) {
            return false;
        }
        UpdateDirectorySetupRequest other = (UpdateDirectorySetupRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.updateTypeAsString(), other.updateTypeAsString()) && Objects.equals(this.osUpdateSettings(), other.osUpdateSettings()) && Objects.equals(this.createSnapshotBeforeUpdate(), other.createSnapshotBeforeUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDirectorySetupRequest").add("DirectoryId", (Object)this.directoryId()).add("UpdateType", (Object)this.updateTypeAsString()).add("OSUpdateSettings", (Object)this.osUpdateSettings()).add("CreateSnapshotBeforeUpdate", (Object)this.createSnapshotBeforeUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "UpdateType": {
                return Optional.ofNullable(clazz.cast(this.updateTypeAsString()));
            }
            case "OSUpdateSettings": {
                return Optional.ofNullable(clazz.cast(this.osUpdateSettings()));
            }
            case "CreateSnapshotBeforeUpdate": {
                return Optional.ofNullable(clazz.cast(this.createSnapshotBeforeUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("UpdateType", UPDATE_TYPE_FIELD);
        map.put("OSUpdateSettings", OS_UPDATE_SETTINGS_FIELD);
        map.put("CreateSnapshotBeforeUpdate", CREATE_SNAPSHOT_BEFORE_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDirectorySetupRequest, T> g) {
        return obj -> g.apply((UpdateDirectorySetupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private String updateType;
        private OSUpdateSettings osUpdateSettings;
        private Boolean createSnapshotBeforeUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDirectorySetupRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.updateType(model.updateType);
            this.osUpdateSettings(model.osUpdateSettings);
            this.createSnapshotBeforeUpdate(model.createSnapshotBeforeUpdate);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getUpdateType() {
            return this.updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(UpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        public final OSUpdateSettings.Builder getOsUpdateSettings() {
            return this.osUpdateSettings != null ? this.osUpdateSettings.toBuilder() : null;
        }

        public final void setOsUpdateSettings(OSUpdateSettings.BuilderImpl osUpdateSettings) {
            this.osUpdateSettings = osUpdateSettings != null ? osUpdateSettings.build() : null;
        }

        @Override
        public final Builder osUpdateSettings(OSUpdateSettings osUpdateSettings) {
            this.osUpdateSettings = osUpdateSettings;
            return this;
        }

        public final Boolean getCreateSnapshotBeforeUpdate() {
            return this.createSnapshotBeforeUpdate;
        }

        public final void setCreateSnapshotBeforeUpdate(Boolean createSnapshotBeforeUpdate) {
            this.createSnapshotBeforeUpdate = createSnapshotBeforeUpdate;
        }

        @Override
        public final Builder createSnapshotBeforeUpdate(Boolean createSnapshotBeforeUpdate) {
            this.createSnapshotBeforeUpdate = createSnapshotBeforeUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDirectorySetupRequest build() {
            return new UpdateDirectorySetupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDirectorySetupRequest> {
        public Builder directoryId(String var1);

        public Builder updateType(String var1);

        public Builder updateType(UpdateType var1);

        public Builder osUpdateSettings(OSUpdateSettings var1);

        default public Builder osUpdateSettings(Consumer<OSUpdateSettings.Builder> osUpdateSettings) {
            return this.osUpdateSettings((OSUpdateSettings)((OSUpdateSettings.Builder)OSUpdateSettings.builder().applyMutation(osUpdateSettings)).build());
        }

        public Builder createSnapshotBeforeUpdate(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

