/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.concurrent.atomic.AtomicInteger;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.AtomicIntegerStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class AtomicIntegerAttributeConverter
implements AttributeConverter<AtomicInteger> {
    private static final Visitor VISITOR = new Visitor();
    private static final AtomicIntegerStringConverter STRING_CONVERTER = AtomicIntegerStringConverter.create();

    private AtomicIntegerAttributeConverter() {
    }

    @Override
    public EnhancedType<AtomicInteger> type() {
        return EnhancedType.of(AtomicInteger.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    public static AtomicIntegerAttributeConverter create() {
        return new AtomicIntegerAttributeConverter();
    }

    @Override
    public AttributeValue transformFrom(AtomicInteger input) {
        return (AttributeValue)AttributeValue.builder().n(STRING_CONVERTER.toString(input)).build();
    }

    @Override
    public AtomicInteger transformTo(AttributeValue input) {
        if (input.n() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<AtomicInteger> {
        private Visitor() {
            super(AtomicInteger.class, AtomicIntegerAttributeConverter.class);
        }

        @Override
        public AtomicInteger convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }

        @Override
        public AtomicInteger convertNumber(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

