/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedTypeDocumentConfiguration;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public class DocumentAttributeConverter<T>
implements AttributeConverter<T> {
    private final TableSchema<T> tableSchema;
    private final EnhancedType<T> enhancedType;
    private final boolean preserveEmptyObject;
    private final boolean ignoreNulls;

    private DocumentAttributeConverter(TableSchema<T> tableSchema, EnhancedType<T> enhancedType) {
        this.tableSchema = tableSchema;
        this.enhancedType = enhancedType;
        this.preserveEmptyObject = enhancedType.documentConfiguration().map(EnhancedTypeDocumentConfiguration::preserveEmptyObject).orElse(false);
        this.ignoreNulls = enhancedType.documentConfiguration().map(EnhancedTypeDocumentConfiguration::ignoreNulls).orElse(false);
    }

    public static <T> DocumentAttributeConverter<T> create(TableSchema<T> tableSchema, EnhancedType<T> enhancedType) {
        return new DocumentAttributeConverter<T>(tableSchema, enhancedType);
    }

    @Override
    public AttributeValue transformFrom(T input) {
        return (AttributeValue)AttributeValue.builder().m(this.tableSchema.itemToMap(input, this.ignoreNulls)).build();
    }

    @Override
    public T transformTo(AttributeValue input) {
        return this.tableSchema.mapToItem(input.m(), this.preserveEmptyObject);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.M;
    }

    @Override
    public EnhancedType<T> type() {
        return this.enhancedType;
    }
}

