/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EMRContainersConfig;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.ProfilerType;
import software.amazon.awssdk.services.emr.model.Tag;
import software.amazon.awssdk.services.emr.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePersistentAppUiRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, CreatePersistentAppUiRequest> {
    private static final SdkField<String> TARGET_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetResourceArn").getter(CreatePersistentAppUiRequest.getter(CreatePersistentAppUiRequest::targetResourceArn)).setter(CreatePersistentAppUiRequest.setter(Builder::targetResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetResourceArn").build()}).build();
    private static final SdkField<EMRContainersConfig> EMR_CONTAINERS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EMRContainersConfig").getter(CreatePersistentAppUiRequest.getter(CreatePersistentAppUiRequest::emrContainersConfig)).setter(CreatePersistentAppUiRequest.setter(Builder::emrContainersConfig)).constructor(EMRContainersConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EMRContainersConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreatePersistentAppUiRequest.getter(CreatePersistentAppUiRequest::tags)).setter(CreatePersistentAppUiRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> X_REFERER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XReferer").getter(CreatePersistentAppUiRequest.getter(CreatePersistentAppUiRequest::xReferer)).setter(CreatePersistentAppUiRequest.setter(Builder::xReferer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XReferer").build()}).build();
    private static final SdkField<String> PROFILER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfilerType").getter(CreatePersistentAppUiRequest.getter(CreatePersistentAppUiRequest::profilerTypeAsString)).setter(CreatePersistentAppUiRequest.setter(Builder::profilerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilerType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_RESOURCE_ARN_FIELD, EMR_CONTAINERS_CONFIG_FIELD, TAGS_FIELD, X_REFERER_FIELD, PROFILER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePersistentAppUiRequest.memberNameToFieldInitializer();
    private final String targetResourceArn;
    private final EMRContainersConfig emrContainersConfig;
    private final List<Tag> tags;
    private final String xReferer;
    private final String profilerType;

    private CreatePersistentAppUiRequest(BuilderImpl builder) {
        super(builder);
        this.targetResourceArn = builder.targetResourceArn;
        this.emrContainersConfig = builder.emrContainersConfig;
        this.tags = builder.tags;
        this.xReferer = builder.xReferer;
        this.profilerType = builder.profilerType;
    }

    public final String targetResourceArn() {
        return this.targetResourceArn;
    }

    public final EMRContainersConfig emrContainersConfig() {
        return this.emrContainersConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String xReferer() {
        return this.xReferer;
    }

    public final ProfilerType profilerType() {
        return ProfilerType.fromValue(this.profilerType);
    }

    public final String profilerTypeAsString() {
        return this.profilerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.emrContainersConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.xReferer());
        hashCode = 31 * hashCode + Objects.hashCode(this.profilerTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePersistentAppUiRequest)) {
            return false;
        }
        CreatePersistentAppUiRequest other = (CreatePersistentAppUiRequest)((Object)obj);
        return Objects.equals(this.targetResourceArn(), other.targetResourceArn()) && Objects.equals(this.emrContainersConfig(), other.emrContainersConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.xReferer(), other.xReferer()) && Objects.equals(this.profilerTypeAsString(), other.profilerTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePersistentAppUiRequest").add("TargetResourceArn", (Object)this.targetResourceArn()).add("EMRContainersConfig", (Object)this.emrContainersConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("XReferer", (Object)this.xReferer()).add("ProfilerType", (Object)this.profilerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetResourceArn": {
                return Optional.ofNullable(clazz.cast(this.targetResourceArn()));
            }
            case "EMRContainersConfig": {
                return Optional.ofNullable(clazz.cast(this.emrContainersConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "XReferer": {
                return Optional.ofNullable(clazz.cast(this.xReferer()));
            }
            case "ProfilerType": {
                return Optional.ofNullable(clazz.cast(this.profilerTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TargetResourceArn", TARGET_RESOURCE_ARN_FIELD);
        map.put("EMRContainersConfig", EMR_CONTAINERS_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("XReferer", X_REFERER_FIELD);
        map.put("ProfilerType", PROFILER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePersistentAppUiRequest, T> g) {
        return obj -> g.apply((CreatePersistentAppUiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String targetResourceArn;
        private EMRContainersConfig emrContainersConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String xReferer;
        private String profilerType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePersistentAppUiRequest model) {
            super(model);
            this.targetResourceArn(model.targetResourceArn);
            this.emrContainersConfig(model.emrContainersConfig);
            this.tags(model.tags);
            this.xReferer(model.xReferer);
            this.profilerType(model.profilerType);
        }

        public final String getTargetResourceArn() {
            return this.targetResourceArn;
        }

        public final void setTargetResourceArn(String targetResourceArn) {
            this.targetResourceArn = targetResourceArn;
        }

        @Override
        public final Builder targetResourceArn(String targetResourceArn) {
            this.targetResourceArn = targetResourceArn;
            return this;
        }

        public final EMRContainersConfig.Builder getEmrContainersConfig() {
            return this.emrContainersConfig != null ? this.emrContainersConfig.toBuilder() : null;
        }

        public final void setEmrContainersConfig(EMRContainersConfig.BuilderImpl emrContainersConfig) {
            this.emrContainersConfig = emrContainersConfig != null ? emrContainersConfig.build() : null;
        }

        @Override
        public final Builder emrContainersConfig(EMRContainersConfig emrContainersConfig) {
            this.emrContainersConfig = emrContainersConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getXReferer() {
            return this.xReferer;
        }

        public final void setXReferer(String xReferer) {
            this.xReferer = xReferer;
        }

        @Override
        public final Builder xReferer(String xReferer) {
            this.xReferer = xReferer;
            return this;
        }

        public final String getProfilerType() {
            return this.profilerType;
        }

        public final void setProfilerType(String profilerType) {
            this.profilerType = profilerType;
        }

        @Override
        public final Builder profilerType(String profilerType) {
            this.profilerType = profilerType;
            return this;
        }

        @Override
        public final Builder profilerType(ProfilerType profilerType) {
            this.profilerType(profilerType == null ? null : profilerType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePersistentAppUiRequest build() {
            return new CreatePersistentAppUiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePersistentAppUiRequest> {
        public Builder targetResourceArn(String var1);

        public Builder emrContainersConfig(EMRContainersConfig var1);

        default public Builder emrContainersConfig(Consumer<EMRContainersConfig.Builder> emrContainersConfig) {
            return this.emrContainersConfig((EMRContainersConfig)((EMRContainersConfig.Builder)EMRContainersConfig.builder().applyMutation(emrContainersConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder xReferer(String var1);

        public Builder profilerType(String var1);

        public Builder profilerType(ProfilerType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

