/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StepState {
    PENDING("PENDING"),
    CANCEL_PENDING("CANCEL_PENDING"),
    RUNNING("RUNNING"),
    COMPLETED("COMPLETED"),
    CANCELLED("CANCELLED"),
    FAILED("FAILED"),
    INTERRUPTED("INTERRUPTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StepState> VALUE_MAP;
    private final String value;

    private StepState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StepState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StepState> knownValues() {
        EnumSet<StepState> knownValues = EnumSet.allOf(StepState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StepState.class, StepState::toString);
    }
}

