/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FlexMatchMode {
    STANDALONE("STANDALONE"),
    WITH_QUEUE("WITH_QUEUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FlexMatchMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FlexMatchMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FlexMatchMode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FlexMatchMode> knownValues() {
        return Stream.of(FlexMatchMode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

