/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.ApplicationConfig;
import software.amazon.awssdk.services.iotwireless.model.ApplicationsCopier;
import software.amazon.awssdk.services.iotwireless.model.Positioning;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FPorts
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FPorts> {
    private static final SdkField<Integer> FUOTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Fuota").getter(FPorts.getter(FPorts::fuota)).setter(FPorts.setter(Builder::fuota)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fuota").build()}).build();
    private static final SdkField<Integer> MULTICAST_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Multicast").getter(FPorts.getter(FPorts::multicast)).setter(FPorts.setter(Builder::multicast)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Multicast").build()}).build();
    private static final SdkField<Integer> CLOCK_SYNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ClockSync").getter(FPorts.getter(FPorts::clockSync)).setter(FPorts.setter(Builder::clockSync)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClockSync").build()}).build();
    private static final SdkField<Positioning> POSITIONING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Positioning").getter(FPorts.getter(FPorts::positioning)).setter(FPorts.setter(Builder::positioning)).constructor(Positioning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Positioning").build()}).build();
    private static final SdkField<List<ApplicationConfig>> APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Applications").getter(FPorts.getter(FPorts::applications)).setter(FPorts.setter(Builder::applications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUOTA_FIELD, MULTICAST_FIELD, CLOCK_SYNC_FIELD, POSITIONING_FIELD, APPLICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FPorts.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer fuota;
    private final Integer multicast;
    private final Integer clockSync;
    private final Positioning positioning;
    private final List<ApplicationConfig> applications;

    private FPorts(BuilderImpl builder) {
        this.fuota = builder.fuota;
        this.multicast = builder.multicast;
        this.clockSync = builder.clockSync;
        this.positioning = builder.positioning;
        this.applications = builder.applications;
    }

    public final Integer fuota() {
        return this.fuota;
    }

    public final Integer multicast() {
        return this.multicast;
    }

    public final Integer clockSync() {
        return this.clockSync;
    }

    public final Positioning positioning() {
        return this.positioning;
    }

    public final boolean hasApplications() {
        return this.applications != null && !(this.applications instanceof SdkAutoConstructList);
    }

    public final List<ApplicationConfig> applications() {
        return this.applications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fuota());
        hashCode = 31 * hashCode + Objects.hashCode(this.multicast());
        hashCode = 31 * hashCode + Objects.hashCode(this.clockSync());
        hashCode = 31 * hashCode + Objects.hashCode(this.positioning());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplications() ? this.applications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FPorts)) {
            return false;
        }
        FPorts other = (FPorts)obj;
        return Objects.equals(this.fuota(), other.fuota()) && Objects.equals(this.multicast(), other.multicast()) && Objects.equals(this.clockSync(), other.clockSync()) && Objects.equals(this.positioning(), other.positioning()) && this.hasApplications() == other.hasApplications() && Objects.equals(this.applications(), other.applications());
    }

    public final String toString() {
        return ToString.builder((String)"FPorts").add("Fuota", (Object)this.fuota()).add("Multicast", (Object)this.multicast()).add("ClockSync", (Object)this.clockSync()).add("Positioning", (Object)this.positioning()).add("Applications", this.hasApplications() ? this.applications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fuota": {
                return Optional.ofNullable(clazz.cast(this.fuota()));
            }
            case "Multicast": {
                return Optional.ofNullable(clazz.cast(this.multicast()));
            }
            case "ClockSync": {
                return Optional.ofNullable(clazz.cast(this.clockSync()));
            }
            case "Positioning": {
                return Optional.ofNullable(clazz.cast(this.positioning()));
            }
            case "Applications": {
                return Optional.ofNullable(clazz.cast(this.applications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Fuota", FUOTA_FIELD);
        map.put("Multicast", MULTICAST_FIELD);
        map.put("ClockSync", CLOCK_SYNC_FIELD);
        map.put("Positioning", POSITIONING_FIELD);
        map.put("Applications", APPLICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FPorts, T> g) {
        return obj -> g.apply((FPorts)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fuota;
        private Integer multicast;
        private Integer clockSync;
        private Positioning positioning;
        private List<ApplicationConfig> applications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FPorts model) {
            this.fuota(model.fuota);
            this.multicast(model.multicast);
            this.clockSync(model.clockSync);
            this.positioning(model.positioning);
            this.applications(model.applications);
        }

        public final Integer getFuota() {
            return this.fuota;
        }

        public final void setFuota(Integer fuota) {
            this.fuota = fuota;
        }

        @Override
        public final Builder fuota(Integer fuota) {
            this.fuota = fuota;
            return this;
        }

        public final Integer getMulticast() {
            return this.multicast;
        }

        public final void setMulticast(Integer multicast) {
            this.multicast = multicast;
        }

        @Override
        public final Builder multicast(Integer multicast) {
            this.multicast = multicast;
            return this;
        }

        public final Integer getClockSync() {
            return this.clockSync;
        }

        public final void setClockSync(Integer clockSync) {
            this.clockSync = clockSync;
        }

        @Override
        public final Builder clockSync(Integer clockSync) {
            this.clockSync = clockSync;
            return this;
        }

        public final Positioning.Builder getPositioning() {
            return this.positioning != null ? this.positioning.toBuilder() : null;
        }

        public final void setPositioning(Positioning.BuilderImpl positioning) {
            this.positioning = positioning != null ? positioning.build() : null;
        }

        @Override
        public final Builder positioning(Positioning positioning) {
            this.positioning = positioning;
            return this;
        }

        public final List<ApplicationConfig.Builder> getApplications() {
            List<ApplicationConfig.Builder> result = ApplicationsCopier.copyToBuilder(this.applications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplications(Collection<ApplicationConfig.BuilderImpl> applications) {
            this.applications = ApplicationsCopier.copyFromBuilder(applications);
        }

        @Override
        public final Builder applications(Collection<ApplicationConfig> applications) {
            this.applications = ApplicationsCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(ApplicationConfig ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Consumer<ApplicationConfig.Builder> ... applications) {
            this.applications(Stream.of(applications).map(c -> (ApplicationConfig)((ApplicationConfig.Builder)ApplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FPorts build() {
            return new FPorts(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FPorts> {
        public Builder fuota(Integer var1);

        public Builder multicast(Integer var1);

        public Builder clockSync(Integer var1);

        public Builder positioning(Positioning var1);

        default public Builder positioning(Consumer<Positioning.Builder> positioning) {
            return this.positioning((Positioning)((Positioning.Builder)Positioning.builder().applyMutation(positioning)).build());
        }

        public Builder applications(Collection<ApplicationConfig> var1);

        public Builder applications(ApplicationConfig ... var1);

        public Builder applications(Consumer<ApplicationConfig.Builder> ... var1);
    }
}

