/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivsrealtime.model.IngestConfigurationState;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIngestConfigurationsRequest
extends IvsRealTimeRequest
implements ToCopyableBuilder<Builder, ListIngestConfigurationsRequest> {
    private static final SdkField<String> FILTER_BY_STAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterByStageArn").getter(ListIngestConfigurationsRequest.getter(ListIngestConfigurationsRequest::filterByStageArn)).setter(ListIngestConfigurationsRequest.setter(Builder::filterByStageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByStageArn").build()}).build();
    private static final SdkField<String> FILTER_BY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterByState").getter(ListIngestConfigurationsRequest.getter(ListIngestConfigurationsRequest::filterByStateAsString)).setter(ListIngestConfigurationsRequest.setter(Builder::filterByState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByState").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListIngestConfigurationsRequest.getter(ListIngestConfigurationsRequest::nextToken)).setter(ListIngestConfigurationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListIngestConfigurationsRequest.getter(ListIngestConfigurationsRequest::maxResults)).setter(ListIngestConfigurationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_BY_STAGE_ARN_FIELD, FILTER_BY_STATE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIngestConfigurationsRequest.memberNameToFieldInitializer();
    private final String filterByStageArn;
    private final String filterByState;
    private final String nextToken;
    private final Integer maxResults;

    private ListIngestConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.filterByStageArn = builder.filterByStageArn;
        this.filterByState = builder.filterByState;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String filterByStageArn() {
        return this.filterByStageArn;
    }

    public final IngestConfigurationState filterByState() {
        return IngestConfigurationState.fromValue(this.filterByState);
    }

    public final String filterByStateAsString() {
        return this.filterByState;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filterByStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterByStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIngestConfigurationsRequest)) {
            return false;
        }
        ListIngestConfigurationsRequest other = (ListIngestConfigurationsRequest)((Object)obj);
        return Objects.equals(this.filterByStageArn(), other.filterByStageArn()) && Objects.equals(this.filterByStateAsString(), other.filterByStateAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListIngestConfigurationsRequest").add("FilterByStageArn", (Object)this.filterByStageArn()).add("FilterByState", (Object)this.filterByStateAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterByStageArn": {
                return Optional.ofNullable(clazz.cast(this.filterByStageArn()));
            }
            case "filterByState": {
                return Optional.ofNullable(clazz.cast(this.filterByStateAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filterByStageArn", FILTER_BY_STAGE_ARN_FIELD);
        map.put("filterByState", FILTER_BY_STATE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIngestConfigurationsRequest, T> g) {
        return obj -> g.apply((ListIngestConfigurationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeRequest.BuilderImpl
    implements Builder {
        private String filterByStageArn;
        private String filterByState;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIngestConfigurationsRequest model) {
            super(model);
            this.filterByStageArn(model.filterByStageArn);
            this.filterByState(model.filterByState);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getFilterByStageArn() {
            return this.filterByStageArn;
        }

        public final void setFilterByStageArn(String filterByStageArn) {
            this.filterByStageArn = filterByStageArn;
        }

        @Override
        public final Builder filterByStageArn(String filterByStageArn) {
            this.filterByStageArn = filterByStageArn;
            return this;
        }

        public final String getFilterByState() {
            return this.filterByState;
        }

        public final void setFilterByState(String filterByState) {
            this.filterByState = filterByState;
        }

        @Override
        public final Builder filterByState(String filterByState) {
            this.filterByState = filterByState;
            return this;
        }

        @Override
        public final Builder filterByState(IngestConfigurationState filterByState) {
            this.filterByState(filterByState == null ? null : filterByState.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIngestConfigurationsRequest build() {
            return new ListIngestConfigurationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IvsRealTimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIngestConfigurationsRequest> {
        public Builder filterByStageArn(String var1);

        public Builder filterByState(String var1);

        public Builder filterByState(IngestConfigurationState var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

