/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.BatchGetDevicePositionError;
import software.amazon.awssdk.services.location.model.BatchGetDevicePositionErrorListCopier;
import software.amazon.awssdk.services.location.model.DevicePosition;
import software.amazon.awssdk.services.location.model.DevicePositionListCopier;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetDevicePositionResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, BatchGetDevicePositionResponse> {
    private static final SdkField<List<DevicePosition>> DEVICE_POSITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DevicePositions").getter(BatchGetDevicePositionResponse.getter(BatchGetDevicePositionResponse::devicePositions)).setter(BatchGetDevicePositionResponse.setter(Builder::devicePositions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevicePositions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DevicePosition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetDevicePositionError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchGetDevicePositionResponse.getter(BatchGetDevicePositionResponse::errors)).setter(BatchGetDevicePositionResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetDevicePositionError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_POSITIONS_FIELD, ERRORS_FIELD));
    private final List<DevicePosition> devicePositions;
    private final List<BatchGetDevicePositionError> errors;

    private BatchGetDevicePositionResponse(BuilderImpl builder) {
        super(builder);
        this.devicePositions = builder.devicePositions;
        this.errors = builder.errors;
    }

    public final boolean hasDevicePositions() {
        return this.devicePositions != null && !(this.devicePositions instanceof SdkAutoConstructList);
    }

    public final List<DevicePosition> devicePositions() {
        return this.devicePositions;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetDevicePositionError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDevicePositions() ? this.devicePositions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDevicePositionResponse)) {
            return false;
        }
        BatchGetDevicePositionResponse other = (BatchGetDevicePositionResponse)((Object)obj);
        return this.hasDevicePositions() == other.hasDevicePositions() && Objects.equals(this.devicePositions(), other.devicePositions()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetDevicePositionResponse").add("DevicePositions", this.hasDevicePositions() ? this.devicePositions() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DevicePositions": {
                return Optional.ofNullable(clazz.cast(this.devicePositions()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDevicePositionResponse, T> g) {
        return obj -> g.apply((BatchGetDevicePositionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private List<DevicePosition> devicePositions = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetDevicePositionError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDevicePositionResponse model) {
            super(model);
            this.devicePositions(model.devicePositions);
            this.errors(model.errors);
        }

        public final Collection<DevicePosition.Builder> getDevicePositions() {
            if (this.devicePositions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.devicePositions != null ? (Collection)this.devicePositions.stream().map(DevicePosition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devicePositions(Collection<DevicePosition> devicePositions) {
            this.devicePositions = DevicePositionListCopier.copy(devicePositions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devicePositions(DevicePosition ... devicePositions) {
            this.devicePositions(Arrays.asList(devicePositions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devicePositions(Consumer<DevicePosition.Builder> ... devicePositions) {
            this.devicePositions(Stream.of(devicePositions).map(c -> (DevicePosition)((DevicePosition.Builder)DevicePosition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevicePositions(Collection<DevicePosition.BuilderImpl> devicePositions) {
            this.devicePositions = DevicePositionListCopier.copyFromBuilder(devicePositions);
        }

        public final Collection<BatchGetDevicePositionError.Builder> getErrors() {
            if (this.errors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errors != null ? (Collection)this.errors.stream().map(BatchGetDevicePositionError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<BatchGetDevicePositionError> errors) {
            this.errors = BatchGetDevicePositionErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetDevicePositionError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetDevicePositionError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetDevicePositionError)((BatchGetDevicePositionError.Builder)BatchGetDevicePositionError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchGetDevicePositionError.BuilderImpl> errors) {
            this.errors = BatchGetDevicePositionErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchGetDevicePositionResponse build() {
            return new BatchGetDevicePositionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetDevicePositionResponse> {
        public Builder devicePositions(Collection<DevicePosition> var1);

        public Builder devicePositions(DevicePosition ... var1);

        public Builder devicePositions(Consumer<DevicePosition.Builder> ... var1);

        public Builder errors(Collection<BatchGetDevicePositionError> var1);

        public Builder errors(BatchGetDevicePositionError ... var1);

        public Builder errors(Consumer<BatchGetDevicePositionError.Builder> ... var1);
    }
}

