/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionRequestUpdatesListCopier;
import software.amazon.awssdk.services.location.model.DevicePositionUpdate;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateDevicePositionRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, BatchUpdateDevicePositionRequest> {
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerName").getter(BatchUpdateDevicePositionRequest.getter(BatchUpdateDevicePositionRequest::trackerName)).setter(BatchUpdateDevicePositionRequest.setter(Builder::trackerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TrackerName").build()}).build();
    private static final SdkField<List<DevicePositionUpdate>> UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Updates").getter(BatchUpdateDevicePositionRequest.getter(BatchUpdateDevicePositionRequest::updates)).setter(BatchUpdateDevicePositionRequest.setter(Builder::updates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DevicePositionUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKER_NAME_FIELD, UPDATES_FIELD));
    private final String trackerName;
    private final List<DevicePositionUpdate> updates;

    private BatchUpdateDevicePositionRequest(BuilderImpl builder) {
        super(builder);
        this.trackerName = builder.trackerName;
        this.updates = builder.updates;
    }

    public final String trackerName() {
        return this.trackerName;
    }

    public final boolean hasUpdates() {
        return this.updates != null && !(this.updates instanceof SdkAutoConstructList);
    }

    public final List<DevicePositionUpdate> updates() {
        return this.updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdates() ? this.updates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateDevicePositionRequest)) {
            return false;
        }
        BatchUpdateDevicePositionRequest other = (BatchUpdateDevicePositionRequest)((Object)obj);
        return Objects.equals(this.trackerName(), other.trackerName()) && this.hasUpdates() == other.hasUpdates() && Objects.equals(this.updates(), other.updates());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateDevicePositionRequest").add("TrackerName", (Object)this.trackerName()).add("Updates", this.hasUpdates() ? this.updates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrackerName": {
                return Optional.ofNullable(clazz.cast(this.trackerName()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateDevicePositionRequest, T> g) {
        return obj -> g.apply((BatchUpdateDevicePositionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String trackerName;
        private List<DevicePositionUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateDevicePositionRequest model) {
            super(model);
            this.trackerName(model.trackerName);
            this.updates(model.updates);
        }

        public final String getTrackerName() {
            return this.trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        public final Collection<DevicePositionUpdate.Builder> getUpdates() {
            if (this.updates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.updates != null ? (Collection)this.updates.stream().map(DevicePositionUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<DevicePositionUpdate> updates) {
            this.updates = BatchUpdateDevicePositionRequestUpdatesListCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(DevicePositionUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<DevicePositionUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (DevicePositionUpdate)((DevicePositionUpdate.Builder)DevicePositionUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdates(Collection<DevicePositionUpdate.BuilderImpl> updates) {
            this.updates = BatchUpdateDevicePositionRequestUpdatesListCopier.copyFromBuilder(updates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateDevicePositionRequest build() {
            return new BatchUpdateDevicePositionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateDevicePositionRequest> {
        public Builder trackerName(String var1);

        public Builder updates(Collection<DevicePositionUpdate> var1);

        public Builder updates(DevicePositionUpdate ... var1);

        public Builder updates(Consumer<DevicePositionUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

