/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.PlaceGeometry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Place
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Place> {
    private static final SdkField<String> ADDRESS_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressNumber").getter(Place.getter(Place::addressNumber)).setter(Place.setter(Builder::addressNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressNumber").build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(Place.getter(Place::country)).setter(Place.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<PlaceGeometry> GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Geometry").getter(Place.getter(Place::geometry)).setter(Place.setter(Builder::geometry)).constructor(PlaceGeometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(Place.getter(Place::label)).setter(Place.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<String> MUNICIPALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Municipality").getter(Place.getter(Place::municipality)).setter(Place.setter(Builder::municipality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Municipality").build()}).build();
    private static final SdkField<String> NEIGHBORHOOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Neighborhood").getter(Place.getter(Place::neighborhood)).setter(Place.setter(Builder::neighborhood)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Neighborhood").build()}).build();
    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostalCode").getter(Place.getter(Place::postalCode)).setter(Place.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(Place.getter(Place::region)).setter(Place.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> STREET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Street").getter(Place.getter(Place::street)).setter(Place.setter(Builder::street)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street").build()}).build();
    private static final SdkField<String> SUB_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubRegion").getter(Place.getter(Place::subRegion)).setter(Place.setter(Builder::subRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_NUMBER_FIELD, COUNTRY_FIELD, GEOMETRY_FIELD, LABEL_FIELD, MUNICIPALITY_FIELD, NEIGHBORHOOD_FIELD, POSTAL_CODE_FIELD, REGION_FIELD, STREET_FIELD, SUB_REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String addressNumber;
    private final String country;
    private final PlaceGeometry geometry;
    private final String label;
    private final String municipality;
    private final String neighborhood;
    private final String postalCode;
    private final String region;
    private final String street;
    private final String subRegion;

    private Place(BuilderImpl builder) {
        this.addressNumber = builder.addressNumber;
        this.country = builder.country;
        this.geometry = builder.geometry;
        this.label = builder.label;
        this.municipality = builder.municipality;
        this.neighborhood = builder.neighborhood;
        this.postalCode = builder.postalCode;
        this.region = builder.region;
        this.street = builder.street;
        this.subRegion = builder.subRegion;
    }

    public final String addressNumber() {
        return this.addressNumber;
    }

    public final String country() {
        return this.country;
    }

    public final PlaceGeometry geometry() {
        return this.geometry;
    }

    public final String label() {
        return this.label;
    }

    public final String municipality() {
        return this.municipality;
    }

    public final String neighborhood() {
        return this.neighborhood;
    }

    public final String postalCode() {
        return this.postalCode;
    }

    public final String region() {
        return this.region;
    }

    public final String street() {
        return this.street;
    }

    public final String subRegion() {
        return this.subRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addressNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometry());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.municipality());
        hashCode = 31 * hashCode + Objects.hashCode(this.neighborhood());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.street());
        hashCode = 31 * hashCode + Objects.hashCode(this.subRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Place)) {
            return false;
        }
        Place other = (Place)obj;
        return Objects.equals(this.addressNumber(), other.addressNumber()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.geometry(), other.geometry()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.municipality(), other.municipality()) && Objects.equals(this.neighborhood(), other.neighborhood()) && Objects.equals(this.postalCode(), other.postalCode()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.street(), other.street()) && Objects.equals(this.subRegion(), other.subRegion());
    }

    public final String toString() {
        return ToString.builder((String)"Place").add("AddressNumber", (Object)this.addressNumber()).add("Country", (Object)this.country()).add("Geometry", (Object)this.geometry()).add("Label", (Object)this.label()).add("Municipality", (Object)this.municipality()).add("Neighborhood", (Object)this.neighborhood()).add("PostalCode", (Object)this.postalCode()).add("Region", (Object)this.region()).add("Street", (Object)this.street()).add("SubRegion", (Object)this.subRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddressNumber": {
                return Optional.ofNullable(clazz.cast(this.addressNumber()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Geometry": {
                return Optional.ofNullable(clazz.cast(this.geometry()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "Municipality": {
                return Optional.ofNullable(clazz.cast(this.municipality()));
            }
            case "Neighborhood": {
                return Optional.ofNullable(clazz.cast(this.neighborhood()));
            }
            case "PostalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "Street": {
                return Optional.ofNullable(clazz.cast(this.street()));
            }
            case "SubRegion": {
                return Optional.ofNullable(clazz.cast(this.subRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Place, T> g) {
        return obj -> g.apply((Place)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String addressNumber;
        private String country;
        private PlaceGeometry geometry;
        private String label;
        private String municipality;
        private String neighborhood;
        private String postalCode;
        private String region;
        private String street;
        private String subRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(Place model) {
            this.addressNumber(model.addressNumber);
            this.country(model.country);
            this.geometry(model.geometry);
            this.label(model.label);
            this.municipality(model.municipality);
            this.neighborhood(model.neighborhood);
            this.postalCode(model.postalCode);
            this.region(model.region);
            this.street(model.street);
            this.subRegion(model.subRegion);
        }

        public final String getAddressNumber() {
            return this.addressNumber;
        }

        @Override
        public final Builder addressNumber(String addressNumber) {
            this.addressNumber = addressNumber;
            return this;
        }

        public final void setAddressNumber(String addressNumber) {
            this.addressNumber = addressNumber;
        }

        public final String getCountry() {
            return this.country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        public final PlaceGeometry.Builder getGeometry() {
            return this.geometry != null ? this.geometry.toBuilder() : null;
        }

        @Override
        public final Builder geometry(PlaceGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final void setGeometry(PlaceGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final String getMunicipality() {
            return this.municipality;
        }

        @Override
        public final Builder municipality(String municipality) {
            this.municipality = municipality;
            return this;
        }

        public final void setMunicipality(String municipality) {
            this.municipality = municipality;
        }

        public final String getNeighborhood() {
            return this.neighborhood;
        }

        @Override
        public final Builder neighborhood(String neighborhood) {
            this.neighborhood = neighborhood;
            return this;
        }

        public final void setNeighborhood(String neighborhood) {
            this.neighborhood = neighborhood;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getStreet() {
            return this.street;
        }

        @Override
        public final Builder street(String street) {
            this.street = street;
            return this;
        }

        public final void setStreet(String street) {
            this.street = street;
        }

        public final String getSubRegion() {
            return this.subRegion;
        }

        @Override
        public final Builder subRegion(String subRegion) {
            this.subRegion = subRegion;
            return this;
        }

        public final void setSubRegion(String subRegion) {
            this.subRegion = subRegion;
        }

        public Place build() {
            return new Place(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Place> {
        public Builder addressNumber(String var1);

        public Builder country(String var1);

        public Builder geometry(PlaceGeometry var1);

        default public Builder geometry(Consumer<PlaceGeometry.Builder> geometry) {
            return this.geometry((PlaceGeometry)((PlaceGeometry.Builder)PlaceGeometry.builder().applyMutation(geometry)).build());
        }

        public Builder label(String var1);

        public Builder municipality(String var1);

        public Builder neighborhood(String var1);

        public Builder postalCode(String var1);

        public Builder region(String var1);

        public Builder street(String var1);

        public Builder subRegion(String var1);
    }
}

