/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteType {
    PROPAGATED("PROPAGATED"),
    STATIC("STATIC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteType> VALUE_MAP;
    private final String value;

    private RouteType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteType> knownValues() {
        EnumSet<RouteType> knownValues = EnumSet.allOf(RouteType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteType.class, RouteType::toString);
    }
}

