/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.TransitGatewayConnectPeerAssociationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayConnectPeerAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayConnectPeerAssociation> {
    private static final SdkField<String> TRANSIT_GATEWAY_CONNECT_PEER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayConnectPeerArn").getter(TransitGatewayConnectPeerAssociation.getter(TransitGatewayConnectPeerAssociation::transitGatewayConnectPeerArn)).setter(TransitGatewayConnectPeerAssociation.setter(Builder::transitGatewayConnectPeerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayConnectPeerArn").build()}).build();
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalNetworkId").getter(TransitGatewayConnectPeerAssociation.getter(TransitGatewayConnectPeerAssociation::globalNetworkId)).setter(TransitGatewayConnectPeerAssociation.setter(Builder::globalNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworkId").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(TransitGatewayConnectPeerAssociation.getter(TransitGatewayConnectPeerAssociation::deviceId)).setter(TransitGatewayConnectPeerAssociation.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<String> LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkId").getter(TransitGatewayConnectPeerAssociation.getter(TransitGatewayConnectPeerAssociation::linkId)).setter(TransitGatewayConnectPeerAssociation.setter(Builder::linkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TransitGatewayConnectPeerAssociation.getter(TransitGatewayConnectPeerAssociation::stateAsString)).setter(TransitGatewayConnectPeerAssociation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_CONNECT_PEER_ARN_FIELD, GLOBAL_NETWORK_ID_FIELD, DEVICE_ID_FIELD, LINK_ID_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransitGatewayConnectPeerAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String transitGatewayConnectPeerArn;
    private final String globalNetworkId;
    private final String deviceId;
    private final String linkId;
    private final String state;

    private TransitGatewayConnectPeerAssociation(BuilderImpl builder) {
        this.transitGatewayConnectPeerArn = builder.transitGatewayConnectPeerArn;
        this.globalNetworkId = builder.globalNetworkId;
        this.deviceId = builder.deviceId;
        this.linkId = builder.linkId;
        this.state = builder.state;
    }

    public final String transitGatewayConnectPeerArn() {
        return this.transitGatewayConnectPeerArn;
    }

    public final String globalNetworkId() {
        return this.globalNetworkId;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final String linkId() {
        return this.linkId;
    }

    public final TransitGatewayConnectPeerAssociationState state() {
        return TransitGatewayConnectPeerAssociationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayConnectPeerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayConnectPeerAssociation)) {
            return false;
        }
        TransitGatewayConnectPeerAssociation other = (TransitGatewayConnectPeerAssociation)obj;
        return Objects.equals(this.transitGatewayConnectPeerArn(), other.transitGatewayConnectPeerArn()) && Objects.equals(this.globalNetworkId(), other.globalNetworkId()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.linkId(), other.linkId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayConnectPeerAssociation").add("TransitGatewayConnectPeerArn", (Object)this.transitGatewayConnectPeerArn()).add("GlobalNetworkId", (Object)this.globalNetworkId()).add("DeviceId", (Object)this.deviceId()).add("LinkId", (Object)this.linkId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayConnectPeerArn": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayConnectPeerArn()));
            }
            case "GlobalNetworkId": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkId()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "LinkId": {
                return Optional.ofNullable(clazz.cast(this.linkId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TransitGatewayConnectPeerArn", TRANSIT_GATEWAY_CONNECT_PEER_ARN_FIELD);
        map.put("GlobalNetworkId", GLOBAL_NETWORK_ID_FIELD);
        map.put("DeviceId", DEVICE_ID_FIELD);
        map.put("LinkId", LINK_ID_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayConnectPeerAssociation, T> g) {
        return obj -> g.apply((TransitGatewayConnectPeerAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayConnectPeerArn;
        private String globalNetworkId;
        private String deviceId;
        private String linkId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayConnectPeerAssociation model) {
            this.transitGatewayConnectPeerArn(model.transitGatewayConnectPeerArn);
            this.globalNetworkId(model.globalNetworkId);
            this.deviceId(model.deviceId);
            this.linkId(model.linkId);
            this.state(model.state);
        }

        public final String getTransitGatewayConnectPeerArn() {
            return this.transitGatewayConnectPeerArn;
        }

        public final void setTransitGatewayConnectPeerArn(String transitGatewayConnectPeerArn) {
            this.transitGatewayConnectPeerArn = transitGatewayConnectPeerArn;
        }

        @Override
        public final Builder transitGatewayConnectPeerArn(String transitGatewayConnectPeerArn) {
            this.transitGatewayConnectPeerArn = transitGatewayConnectPeerArn;
            return this;
        }

        public final String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getLinkId() {
            return this.linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayConnectPeerAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public TransitGatewayConnectPeerAssociation build() {
            return new TransitGatewayConnectPeerAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayConnectPeerAssociation> {
        public Builder transitGatewayConnectPeerArn(String var1);

        public Builder globalNetworkId(String var1);

        public Builder deviceId(String var1);

        public Builder linkId(String var1);

        public Builder state(String var1);

        public Builder state(TransitGatewayConnectPeerAssociationState var1);
    }
}

