/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksRequest;
import software.amazon.awssdk.services.networkmanager.model.DescribeGlobalNetworksResponse;
import software.amazon.awssdk.services.networkmanager.model.GlobalNetwork;

public class DescribeGlobalNetworksIterable
implements SdkIterable<DescribeGlobalNetworksResponse> {
    private final NetworkManagerClient client;
    private final DescribeGlobalNetworksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeGlobalNetworksIterable(NetworkManagerClient client, DescribeGlobalNetworksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeGlobalNetworksResponseFetcher();
    }

    public Iterator<DescribeGlobalNetworksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GlobalNetwork> globalNetworks() {
        Function<DescribeGlobalNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.globalNetworks() != null) {
                return response.globalNetworks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeGlobalNetworksResponseFetcher
    implements SyncPageFetcher<DescribeGlobalNetworksResponse> {
        private DescribeGlobalNetworksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGlobalNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeGlobalNetworksResponse nextPage(DescribeGlobalNetworksResponse previousPage) {
            if (previousPage == null) {
                return DescribeGlobalNetworksIterable.this.client.describeGlobalNetworks(DescribeGlobalNetworksIterable.this.firstRequest);
            }
            return DescribeGlobalNetworksIterable.this.client.describeGlobalNetworks((DescribeGlobalNetworksRequest)((Object)DescribeGlobalNetworksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

