/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ActivationState;
import software.amazon.awssdk.services.sagemaker.model.ComputeQuotaConfig;
import software.amazon.awssdk.services.sagemaker.model.ComputeQuotaTarget;
import software.amazon.awssdk.services.sagemaker.model.SchedulerResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeQuotaSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeQuotaSummary> {
    private static final SdkField<String> COMPUTE_QUOTA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeQuotaArn").getter(ComputeQuotaSummary.getter(ComputeQuotaSummary::computeQuotaArn)).setter(ComputeQuotaSummary.setter(Builder::computeQuotaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaArn").build()}).build();
    private static final SdkField<String> COMPUTE_QUOTA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeQuotaId").getter(ComputeQuotaSummary.getter(ComputeQuotaSummary::computeQuotaId)).setter(ComputeQuotaSummary.setter(Builder::computeQuotaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ComputeQuotaSummary.getter(ComputeQuotaSummary::name)).setter(ComputeQuotaSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> COMPUTE_QUOTA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ComputeQuotaVersion").getter(ComputeQuotaSummary.getter(ComputeQuotaSummary::computeQuotaVersion)).setter(ComputeQuotaSummary.setter(Builder::computeQuotaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ComputeQuotaSummary.getter(ComputeQuotaSummary::statusAsString)).setter(ComputeQuotaSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(ComputeQuotaSummary.getter(ComputeQuotaSummary::clusterArn)).setter(ComputeQuotaSummary.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final SdkField<ComputeQuotaConfig> COMPUTE_QUOTA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputeQuotaConfig").getter(ComputeQuotaSummary.getter(ComputeQuotaSummary::computeQuotaConfig)).setter(ComputeQuotaSummary.setter(Builder::computeQuotaConfig)).constructor(ComputeQuotaConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaConfig").build()}).build();
    private static final SdkField<ComputeQuotaTarget> COMPUTE_QUOTA_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputeQuotaTarget").getter(ComputeQuotaSummary.getter(ComputeQuotaSummary::computeQuotaTarget)).setter(ComputeQuotaSummary.setter(Builder::computeQuotaTarget)).constructor(ComputeQuotaTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaTarget").build()}).build();
    private static final SdkField<String> ACTIVATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivationState").getter(ComputeQuotaSummary.getter(ComputeQuotaSummary::activationStateAsString)).setter(ComputeQuotaSummary.setter(Builder::activationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationState").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ComputeQuotaSummary.getter(ComputeQuotaSummary::creationTime)).setter(ComputeQuotaSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ComputeQuotaSummary.getter(ComputeQuotaSummary::lastModifiedTime)).setter(ComputeQuotaSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_QUOTA_ARN_FIELD, COMPUTE_QUOTA_ID_FIELD, NAME_FIELD, COMPUTE_QUOTA_VERSION_FIELD, STATUS_FIELD, CLUSTER_ARN_FIELD, COMPUTE_QUOTA_CONFIG_FIELD, COMPUTE_QUOTA_TARGET_FIELD, ACTIVATION_STATE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComputeQuotaSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String computeQuotaArn;
    private final String computeQuotaId;
    private final String name;
    private final Integer computeQuotaVersion;
    private final String status;
    private final String clusterArn;
    private final ComputeQuotaConfig computeQuotaConfig;
    private final ComputeQuotaTarget computeQuotaTarget;
    private final String activationState;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private ComputeQuotaSummary(BuilderImpl builder) {
        this.computeQuotaArn = builder.computeQuotaArn;
        this.computeQuotaId = builder.computeQuotaId;
        this.name = builder.name;
        this.computeQuotaVersion = builder.computeQuotaVersion;
        this.status = builder.status;
        this.clusterArn = builder.clusterArn;
        this.computeQuotaConfig = builder.computeQuotaConfig;
        this.computeQuotaTarget = builder.computeQuotaTarget;
        this.activationState = builder.activationState;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String computeQuotaArn() {
        return this.computeQuotaArn;
    }

    public final String computeQuotaId() {
        return this.computeQuotaId;
    }

    public final String name() {
        return this.name;
    }

    public final Integer computeQuotaVersion() {
        return this.computeQuotaVersion;
    }

    public final SchedulerResourceStatus status() {
        return SchedulerResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final ComputeQuotaConfig computeQuotaConfig() {
        return this.computeQuotaConfig;
    }

    public final ComputeQuotaTarget computeQuotaTarget() {
        return this.computeQuotaTarget;
    }

    public final ActivationState activationState() {
        return ActivationState.fromValue(this.activationState);
    }

    public final String activationStateAsString() {
        return this.activationState;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.activationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeQuotaSummary)) {
            return false;
        }
        ComputeQuotaSummary other = (ComputeQuotaSummary)obj;
        return Objects.equals(this.computeQuotaArn(), other.computeQuotaArn()) && Objects.equals(this.computeQuotaId(), other.computeQuotaId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.computeQuotaVersion(), other.computeQuotaVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.computeQuotaConfig(), other.computeQuotaConfig()) && Objects.equals(this.computeQuotaTarget(), other.computeQuotaTarget()) && Objects.equals(this.activationStateAsString(), other.activationStateAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeQuotaSummary").add("ComputeQuotaArn", (Object)this.computeQuotaArn()).add("ComputeQuotaId", (Object)this.computeQuotaId()).add("Name", (Object)this.name()).add("ComputeQuotaVersion", (Object)this.computeQuotaVersion()).add("Status", (Object)this.statusAsString()).add("ClusterArn", (Object)this.clusterArn()).add("ComputeQuotaConfig", (Object)this.computeQuotaConfig()).add("ComputeQuotaTarget", (Object)this.computeQuotaTarget()).add("ActivationState", (Object)this.activationStateAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComputeQuotaArn": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaArn()));
            }
            case "ComputeQuotaId": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ComputeQuotaVersion": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaVersion()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ComputeQuotaConfig": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaConfig()));
            }
            case "ComputeQuotaTarget": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaTarget()));
            }
            case "ActivationState": {
                return Optional.ofNullable(clazz.cast(this.activationStateAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ComputeQuotaArn", COMPUTE_QUOTA_ARN_FIELD);
        map.put("ComputeQuotaId", COMPUTE_QUOTA_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ComputeQuotaVersion", COMPUTE_QUOTA_VERSION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        map.put("ComputeQuotaConfig", COMPUTE_QUOTA_CONFIG_FIELD);
        map.put("ComputeQuotaTarget", COMPUTE_QUOTA_TARGET_FIELD);
        map.put("ActivationState", ACTIVATION_STATE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeQuotaSummary, T> g) {
        return obj -> g.apply((ComputeQuotaSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String computeQuotaArn;
        private String computeQuotaId;
        private String name;
        private Integer computeQuotaVersion;
        private String status;
        private String clusterArn;
        private ComputeQuotaConfig computeQuotaConfig;
        private ComputeQuotaTarget computeQuotaTarget;
        private String activationState;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeQuotaSummary model) {
            this.computeQuotaArn(model.computeQuotaArn);
            this.computeQuotaId(model.computeQuotaId);
            this.name(model.name);
            this.computeQuotaVersion(model.computeQuotaVersion);
            this.status(model.status);
            this.clusterArn(model.clusterArn);
            this.computeQuotaConfig(model.computeQuotaConfig);
            this.computeQuotaTarget(model.computeQuotaTarget);
            this.activationState(model.activationState);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getComputeQuotaArn() {
            return this.computeQuotaArn;
        }

        public final void setComputeQuotaArn(String computeQuotaArn) {
            this.computeQuotaArn = computeQuotaArn;
        }

        @Override
        public final Builder computeQuotaArn(String computeQuotaArn) {
            this.computeQuotaArn = computeQuotaArn;
            return this;
        }

        public final String getComputeQuotaId() {
            return this.computeQuotaId;
        }

        public final void setComputeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
        }

        @Override
        public final Builder computeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getComputeQuotaVersion() {
            return this.computeQuotaVersion;
        }

        public final void setComputeQuotaVersion(Integer computeQuotaVersion) {
            this.computeQuotaVersion = computeQuotaVersion;
        }

        @Override
        public final Builder computeQuotaVersion(Integer computeQuotaVersion) {
            this.computeQuotaVersion = computeQuotaVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SchedulerResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final ComputeQuotaConfig.Builder getComputeQuotaConfig() {
            return this.computeQuotaConfig != null ? this.computeQuotaConfig.toBuilder() : null;
        }

        public final void setComputeQuotaConfig(ComputeQuotaConfig.BuilderImpl computeQuotaConfig) {
            this.computeQuotaConfig = computeQuotaConfig != null ? computeQuotaConfig.build() : null;
        }

        @Override
        public final Builder computeQuotaConfig(ComputeQuotaConfig computeQuotaConfig) {
            this.computeQuotaConfig = computeQuotaConfig;
            return this;
        }

        public final ComputeQuotaTarget.Builder getComputeQuotaTarget() {
            return this.computeQuotaTarget != null ? this.computeQuotaTarget.toBuilder() : null;
        }

        public final void setComputeQuotaTarget(ComputeQuotaTarget.BuilderImpl computeQuotaTarget) {
            this.computeQuotaTarget = computeQuotaTarget != null ? computeQuotaTarget.build() : null;
        }

        @Override
        public final Builder computeQuotaTarget(ComputeQuotaTarget computeQuotaTarget) {
            this.computeQuotaTarget = computeQuotaTarget;
            return this;
        }

        public final String getActivationState() {
            return this.activationState;
        }

        public final void setActivationState(String activationState) {
            this.activationState = activationState;
        }

        @Override
        public final Builder activationState(String activationState) {
            this.activationState = activationState;
            return this;
        }

        @Override
        public final Builder activationState(ActivationState activationState) {
            this.activationState(activationState == null ? null : activationState.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public ComputeQuotaSummary build() {
            return new ComputeQuotaSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeQuotaSummary> {
        public Builder computeQuotaArn(String var1);

        public Builder computeQuotaId(String var1);

        public Builder name(String var1);

        public Builder computeQuotaVersion(Integer var1);

        public Builder status(String var1);

        public Builder status(SchedulerResourceStatus var1);

        public Builder clusterArn(String var1);

        public Builder computeQuotaConfig(ComputeQuotaConfig var1);

        default public Builder computeQuotaConfig(Consumer<ComputeQuotaConfig.Builder> computeQuotaConfig) {
            return this.computeQuotaConfig((ComputeQuotaConfig)((ComputeQuotaConfig.Builder)ComputeQuotaConfig.builder().applyMutation(computeQuotaConfig)).build());
        }

        public Builder computeQuotaTarget(ComputeQuotaTarget var1);

        default public Builder computeQuotaTarget(Consumer<ComputeQuotaTarget.Builder> computeQuotaTarget) {
            return this.computeQuotaTarget((ComputeQuotaTarget)((ComputeQuotaTarget.Builder)ComputeQuotaTarget.builder().applyMutation(computeQuotaTarget)).build());
        }

        public Builder activationState(String var1);

        public Builder activationState(ActivationState var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

