/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HubStatus {
    IN_SERVICE("InService"),
    CREATING("Creating"),
    UPDATING("Updating"),
    DELETING("Deleting"),
    CREATE_FAILED("CreateFailed"),
    UPDATE_FAILED("UpdateFailed"),
    DELETE_FAILED("DeleteFailed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HubStatus> VALUE_MAP;
    private final String value;

    private HubStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HubStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HubStatus> knownValues() {
        EnumSet<HubStatus> knownValues = EnumSet.allOf(HubStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HubStatus.class, HubStatus::toString);
    }
}

