/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelMetadataSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelMetadataSummary> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(ModelMetadataSummary.getter(ModelMetadataSummary::domain)).setter(ModelMetadataSummary.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Framework").getter(ModelMetadataSummary.getter(ModelMetadataSummary::framework)).setter(ModelMetadataSummary.setter(Builder::framework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()}).build();
    private static final SdkField<String> TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Task").getter(ModelMetadataSummary.getter(ModelMetadataSummary::task)).setter(ModelMetadataSummary.setter(Builder::task)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Task").build()}).build();
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Model").getter(ModelMetadataSummary.getter(ModelMetadataSummary::model)).setter(ModelMetadataSummary.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()}).build();
    private static final SdkField<String> FRAMEWORK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkVersion").getter(ModelMetadataSummary.getter(ModelMetadataSummary::frameworkVersion)).setter(ModelMetadataSummary.setter(Builder::frameworkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, FRAMEWORK_FIELD, TASK_FIELD, MODEL_FIELD, FRAMEWORK_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelMetadataSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domain;
    private final String framework;
    private final String task;
    private final String model;
    private final String frameworkVersion;

    private ModelMetadataSummary(BuilderImpl builder) {
        this.domain = builder.domain;
        this.framework = builder.framework;
        this.task = builder.task;
        this.model = builder.model;
        this.frameworkVersion = builder.frameworkVersion;
    }

    public final String domain() {
        return this.domain;
    }

    public final String framework() {
        return this.framework;
    }

    public final String task() {
        return this.task;
    }

    public final String model() {
        return this.model;
    }

    public final String frameworkVersion() {
        return this.frameworkVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.framework());
        hashCode = 31 * hashCode + Objects.hashCode(this.task());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelMetadataSummary)) {
            return false;
        }
        ModelMetadataSummary other = (ModelMetadataSummary)obj;
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.framework(), other.framework()) && Objects.equals(this.task(), other.task()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.frameworkVersion(), other.frameworkVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ModelMetadataSummary").add("Domain", (Object)this.domain()).add("Framework", (Object)this.framework()).add("Task", (Object)this.task()).add("Model", (Object)this.model()).add("FrameworkVersion", (Object)this.frameworkVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "Framework": {
                return Optional.ofNullable(clazz.cast(this.framework()));
            }
            case "Task": {
                return Optional.ofNullable(clazz.cast(this.task()));
            }
            case "Model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "FrameworkVersion": {
                return Optional.ofNullable(clazz.cast(this.frameworkVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Domain", DOMAIN_FIELD);
        map.put("Framework", FRAMEWORK_FIELD);
        map.put("Task", TASK_FIELD);
        map.put("Model", MODEL_FIELD);
        map.put("FrameworkVersion", FRAMEWORK_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelMetadataSummary, T> g) {
        return obj -> g.apply((ModelMetadataSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domain;
        private String framework;
        private String task;
        private String model;
        private String frameworkVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelMetadataSummary model) {
            this.domain(model.domain);
            this.framework(model.framework);
            this.task(model.task);
            this.model(model.model);
            this.frameworkVersion(model.frameworkVersion);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getFramework() {
            return this.framework;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public final String getTask() {
            return this.task;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        @Override
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final String getModel() {
            return this.model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getFrameworkVersion() {
            return this.frameworkVersion;
        }

        public final void setFrameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
        }

        @Override
        public final Builder frameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
            return this;
        }

        public ModelMetadataSummary build() {
            return new ModelMetadataSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelMetadataSummary> {
        public Builder domain(String var1);

        public Builder framework(String var1);

        public Builder task(String var1);

        public Builder model(String var1);

        public Builder frameworkVersion(String var1);
    }
}

