/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceSharingStrategy {
    LEND("Lend"),
    DONT_LEND("DontLend"),
    LEND_AND_BORROW("LendAndBorrow"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceSharingStrategy> VALUE_MAP;
    private final String value;

    private ResourceSharingStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceSharingStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceSharingStrategy> knownValues() {
        EnumSet<ResourceSharingStrategy> knownValues = EnumSet.allOf(ResourceSharingStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceSharingStrategy.class, ResourceSharingStrategy::toString);
    }
}

