/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SageMakerResourceName {
    TRAINING_JOB("training-job"),
    HYPERPOD_CLUSTER("hyperpod-cluster"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SageMakerResourceName> VALUE_MAP;
    private final String value;

    private SageMakerResourceName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SageMakerResourceName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SageMakerResourceName> knownValues() {
        EnumSet<SageMakerResourceName> knownValues = EnumSet.allOf(SageMakerResourceName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SageMakerResourceName.class, SageMakerResourceName::toString);
    }
}

