/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CodeRepositoriesCopier;
import software.amazon.awssdk.services.sagemaker.model.CodeRepository;
import software.amazon.awssdk.services.sagemaker.model.ResourceSpec;
import software.amazon.awssdk.services.sagemaker.model.SpaceAppLifecycleManagement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpaceJupyterLabAppSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpaceJupyterLabAppSettings> {
    private static final SdkField<ResourceSpec> DEFAULT_RESOURCE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultResourceSpec").getter(SpaceJupyterLabAppSettings.getter(SpaceJupyterLabAppSettings::defaultResourceSpec)).setter(SpaceJupyterLabAppSettings.setter(Builder::defaultResourceSpec)).constructor(ResourceSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceSpec").build()}).build();
    private static final SdkField<List<CodeRepository>> CODE_REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CodeRepositories").getter(SpaceJupyterLabAppSettings.getter(SpaceJupyterLabAppSettings::codeRepositories)).setter(SpaceJupyterLabAppSettings.setter(Builder::codeRepositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SpaceAppLifecycleManagement> APP_LIFECYCLE_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppLifecycleManagement").getter(SpaceJupyterLabAppSettings.getter(SpaceJupyterLabAppSettings::appLifecycleManagement)).setter(SpaceJupyterLabAppSettings.setter(Builder::appLifecycleManagement)).constructor(SpaceAppLifecycleManagement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppLifecycleManagement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_RESOURCE_SPEC_FIELD, CODE_REPOSITORIES_FIELD, APP_LIFECYCLE_MANAGEMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SpaceJupyterLabAppSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ResourceSpec defaultResourceSpec;
    private final List<CodeRepository> codeRepositories;
    private final SpaceAppLifecycleManagement appLifecycleManagement;

    private SpaceJupyterLabAppSettings(BuilderImpl builder) {
        this.defaultResourceSpec = builder.defaultResourceSpec;
        this.codeRepositories = builder.codeRepositories;
        this.appLifecycleManagement = builder.appLifecycleManagement;
    }

    public final ResourceSpec defaultResourceSpec() {
        return this.defaultResourceSpec;
    }

    public final boolean hasCodeRepositories() {
        return this.codeRepositories != null && !(this.codeRepositories instanceof SdkAutoConstructList);
    }

    public final List<CodeRepository> codeRepositories() {
        return this.codeRepositories;
    }

    public final SpaceAppLifecycleManagement appLifecycleManagement() {
        return this.appLifecycleManagement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResourceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCodeRepositories() ? this.codeRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.appLifecycleManagement());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceJupyterLabAppSettings)) {
            return false;
        }
        SpaceJupyterLabAppSettings other = (SpaceJupyterLabAppSettings)obj;
        return Objects.equals(this.defaultResourceSpec(), other.defaultResourceSpec()) && this.hasCodeRepositories() == other.hasCodeRepositories() && Objects.equals(this.codeRepositories(), other.codeRepositories()) && Objects.equals(this.appLifecycleManagement(), other.appLifecycleManagement());
    }

    public final String toString() {
        return ToString.builder((String)"SpaceJupyterLabAppSettings").add("DefaultResourceSpec", (Object)this.defaultResourceSpec()).add("CodeRepositories", this.hasCodeRepositories() ? this.codeRepositories() : null).add("AppLifecycleManagement", (Object)this.appLifecycleManagement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultResourceSpec": {
                return Optional.ofNullable(clazz.cast(this.defaultResourceSpec()));
            }
            case "CodeRepositories": {
                return Optional.ofNullable(clazz.cast(this.codeRepositories()));
            }
            case "AppLifecycleManagement": {
                return Optional.ofNullable(clazz.cast(this.appLifecycleManagement()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultResourceSpec", DEFAULT_RESOURCE_SPEC_FIELD);
        map.put("CodeRepositories", CODE_REPOSITORIES_FIELD);
        map.put("AppLifecycleManagement", APP_LIFECYCLE_MANAGEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpaceJupyterLabAppSettings, T> g) {
        return obj -> g.apply((SpaceJupyterLabAppSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceSpec defaultResourceSpec;
        private List<CodeRepository> codeRepositories = DefaultSdkAutoConstructList.getInstance();
        private SpaceAppLifecycleManagement appLifecycleManagement;

        private BuilderImpl() {
        }

        private BuilderImpl(SpaceJupyterLabAppSettings model) {
            this.defaultResourceSpec(model.defaultResourceSpec);
            this.codeRepositories(model.codeRepositories);
            this.appLifecycleManagement(model.appLifecycleManagement);
        }

        public final ResourceSpec.Builder getDefaultResourceSpec() {
            return this.defaultResourceSpec != null ? this.defaultResourceSpec.toBuilder() : null;
        }

        public final void setDefaultResourceSpec(ResourceSpec.BuilderImpl defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec != null ? defaultResourceSpec.build() : null;
        }

        @Override
        public final Builder defaultResourceSpec(ResourceSpec defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec;
            return this;
        }

        public final List<CodeRepository.Builder> getCodeRepositories() {
            List<CodeRepository.Builder> result = CodeRepositoriesCopier.copyToBuilder(this.codeRepositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeRepositories(Collection<CodeRepository.BuilderImpl> codeRepositories) {
            this.codeRepositories = CodeRepositoriesCopier.copyFromBuilder(codeRepositories);
        }

        @Override
        public final Builder codeRepositories(Collection<CodeRepository> codeRepositories) {
            this.codeRepositories = CodeRepositoriesCopier.copy(codeRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositories(CodeRepository ... codeRepositories) {
            this.codeRepositories(Arrays.asList(codeRepositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositories(Consumer<CodeRepository.Builder> ... codeRepositories) {
            this.codeRepositories(Stream.of(codeRepositories).map(c -> (CodeRepository)((CodeRepository.Builder)CodeRepository.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SpaceAppLifecycleManagement.Builder getAppLifecycleManagement() {
            return this.appLifecycleManagement != null ? this.appLifecycleManagement.toBuilder() : null;
        }

        public final void setAppLifecycleManagement(SpaceAppLifecycleManagement.BuilderImpl appLifecycleManagement) {
            this.appLifecycleManagement = appLifecycleManagement != null ? appLifecycleManagement.build() : null;
        }

        @Override
        public final Builder appLifecycleManagement(SpaceAppLifecycleManagement appLifecycleManagement) {
            this.appLifecycleManagement = appLifecycleManagement;
            return this;
        }

        public SpaceJupyterLabAppSettings build() {
            return new SpaceJupyterLabAppSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpaceJupyterLabAppSettings> {
        public Builder defaultResourceSpec(ResourceSpec var1);

        default public Builder defaultResourceSpec(Consumer<ResourceSpec.Builder> defaultResourceSpec) {
            return this.defaultResourceSpec((ResourceSpec)((ResourceSpec.Builder)ResourceSpec.builder().applyMutation(defaultResourceSpec)).build());
        }

        public Builder codeRepositories(Collection<CodeRepository> var1);

        public Builder codeRepositories(CodeRepository ... var1);

        public Builder codeRepositories(Consumer<CodeRepository.Builder> ... var1);

        public Builder appLifecycleManagement(SpaceAppLifecycleManagement var1);

        default public Builder appLifecycleManagement(Consumer<SpaceAppLifecycleManagement.Builder> appLifecycleManagement) {
            return this.appLifecycleManagement((SpaceAppLifecycleManagement)((SpaceAppLifecycleManagement.Builder)SpaceAppLifecycleManagement.builder().applyMutation(appLifecycleManagement)).build());
        }
    }
}

