/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DesiredWeightAndCapacity;
import software.amazon.awssdk.services.sagemaker.model.DesiredWeightAndCapacityListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEndpointWeightsAndCapacitiesRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateEndpointWeightsAndCapacitiesRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(UpdateEndpointWeightsAndCapacitiesRequest.getter(UpdateEndpointWeightsAndCapacitiesRequest::endpointName)).setter(UpdateEndpointWeightsAndCapacitiesRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<List<DesiredWeightAndCapacity>> DESIRED_WEIGHTS_AND_CAPACITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DesiredWeightsAndCapacities").getter(UpdateEndpointWeightsAndCapacitiesRequest.getter(UpdateEndpointWeightsAndCapacitiesRequest::desiredWeightsAndCapacities)).setter(UpdateEndpointWeightsAndCapacitiesRequest.setter(Builder::desiredWeightsAndCapacities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredWeightsAndCapacities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DesiredWeightAndCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, DESIRED_WEIGHTS_AND_CAPACITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEndpointWeightsAndCapacitiesRequest.memberNameToFieldInitializer();
    private final String endpointName;
    private final List<DesiredWeightAndCapacity> desiredWeightsAndCapacities;

    private UpdateEndpointWeightsAndCapacitiesRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.desiredWeightsAndCapacities = builder.desiredWeightsAndCapacities;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final boolean hasDesiredWeightsAndCapacities() {
        return this.desiredWeightsAndCapacities != null && !(this.desiredWeightsAndCapacities instanceof SdkAutoConstructList);
    }

    public final List<DesiredWeightAndCapacity> desiredWeightsAndCapacities() {
        return this.desiredWeightsAndCapacities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDesiredWeightsAndCapacities() ? this.desiredWeightsAndCapacities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointWeightsAndCapacitiesRequest)) {
            return false;
        }
        UpdateEndpointWeightsAndCapacitiesRequest other = (UpdateEndpointWeightsAndCapacitiesRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && this.hasDesiredWeightsAndCapacities() == other.hasDesiredWeightsAndCapacities() && Objects.equals(this.desiredWeightsAndCapacities(), other.desiredWeightsAndCapacities());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEndpointWeightsAndCapacitiesRequest").add("EndpointName", (Object)this.endpointName()).add("DesiredWeightsAndCapacities", this.hasDesiredWeightsAndCapacities() ? this.desiredWeightsAndCapacities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "DesiredWeightsAndCapacities": {
                return Optional.ofNullable(clazz.cast(this.desiredWeightsAndCapacities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("DesiredWeightsAndCapacities", DESIRED_WEIGHTS_AND_CAPACITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointWeightsAndCapacitiesRequest, T> g) {
        return obj -> g.apply((UpdateEndpointWeightsAndCapacitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String endpointName;
        private List<DesiredWeightAndCapacity> desiredWeightsAndCapacities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointWeightsAndCapacitiesRequest model) {
            super(model);
            this.endpointName(model.endpointName);
            this.desiredWeightsAndCapacities(model.desiredWeightsAndCapacities);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final List<DesiredWeightAndCapacity.Builder> getDesiredWeightsAndCapacities() {
            List<DesiredWeightAndCapacity.Builder> result = DesiredWeightAndCapacityListCopier.copyToBuilder(this.desiredWeightsAndCapacities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDesiredWeightsAndCapacities(Collection<DesiredWeightAndCapacity.BuilderImpl> desiredWeightsAndCapacities) {
            this.desiredWeightsAndCapacities = DesiredWeightAndCapacityListCopier.copyFromBuilder(desiredWeightsAndCapacities);
        }

        @Override
        public final Builder desiredWeightsAndCapacities(Collection<DesiredWeightAndCapacity> desiredWeightsAndCapacities) {
            this.desiredWeightsAndCapacities = DesiredWeightAndCapacityListCopier.copy(desiredWeightsAndCapacities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredWeightsAndCapacities(DesiredWeightAndCapacity ... desiredWeightsAndCapacities) {
            this.desiredWeightsAndCapacities(Arrays.asList(desiredWeightsAndCapacities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredWeightsAndCapacities(Consumer<DesiredWeightAndCapacity.Builder> ... desiredWeightsAndCapacities) {
            this.desiredWeightsAndCapacities(Stream.of(desiredWeightsAndCapacities).map(c -> (DesiredWeightAndCapacity)((DesiredWeightAndCapacity.Builder)DesiredWeightAndCapacity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointWeightsAndCapacitiesRequest build() {
            return new UpdateEndpointWeightsAndCapacitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEndpointWeightsAndCapacitiesRequest> {
        public Builder endpointName(String var1);

        public Builder desiredWeightsAndCapacities(Collection<DesiredWeightAndCapacity> var1);

        public Builder desiredWeightsAndCapacities(DesiredWeightAndCapacity ... var1);

        public Builder desiredWeightsAndCapacities(Consumer<DesiredWeightAndCapacity.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

