/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelCardStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateModelCardRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateModelCardRequest> {
    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardName").getter(UpdateModelCardRequest.getter(UpdateModelCardRequest::modelCardName)).setter(UpdateModelCardRequest.setter(Builder::modelCardName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(UpdateModelCardRequest.getter(UpdateModelCardRequest::content)).setter(UpdateModelCardRequest.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> MODEL_CARD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardStatus").getter(UpdateModelCardRequest.getter(UpdateModelCardRequest::modelCardStatusAsString)).setter(UpdateModelCardRequest.setter(Builder::modelCardStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_NAME_FIELD, CONTENT_FIELD, MODEL_CARD_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateModelCardRequest.memberNameToFieldInitializer();
    private final String modelCardName;
    private final String content;
    private final String modelCardStatus;

    private UpdateModelCardRequest(BuilderImpl builder) {
        super(builder);
        this.modelCardName = builder.modelCardName;
        this.content = builder.content;
        this.modelCardStatus = builder.modelCardStatus;
    }

    public final String modelCardName() {
        return this.modelCardName;
    }

    public final String content() {
        return this.content;
    }

    public final ModelCardStatus modelCardStatus() {
        return ModelCardStatus.fromValue(this.modelCardStatus);
    }

    public final String modelCardStatusAsString() {
        return this.modelCardStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelCardRequest)) {
            return false;
        }
        UpdateModelCardRequest other = (UpdateModelCardRequest)((Object)obj);
        return Objects.equals(this.modelCardName(), other.modelCardName()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.modelCardStatusAsString(), other.modelCardStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateModelCardRequest").add("ModelCardName", (Object)this.modelCardName()).add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).add("ModelCardStatus", (Object)this.modelCardStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelCardName": {
                return Optional.ofNullable(clazz.cast(this.modelCardName()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "ModelCardStatus": {
                return Optional.ofNullable(clazz.cast(this.modelCardStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ModelCardName", MODEL_CARD_NAME_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("ModelCardStatus", MODEL_CARD_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateModelCardRequest, T> g) {
        return obj -> g.apply((UpdateModelCardRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String modelCardName;
        private String content;
        private String modelCardStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateModelCardRequest model) {
            super(model);
            this.modelCardName(model.modelCardName);
            this.content(model.content);
            this.modelCardStatus(model.modelCardStatus);
        }

        public final String getModelCardName() {
            return this.modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getModelCardStatus() {
            return this.modelCardStatus;
        }

        public final void setModelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
        }

        @Override
        public final Builder modelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
            return this;
        }

        @Override
        public final Builder modelCardStatus(ModelCardStatus modelCardStatus) {
            this.modelCardStatus(modelCardStatus == null ? null : modelCardStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateModelCardRequest build() {
            return new UpdateModelCardRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateModelCardRequest> {
        public Builder modelCardName(String var1);

        public Builder content(String var1);

        public Builder modelCardStatus(String var1);

        public Builder modelCardStatus(ModelCardStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

