/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ArtifactSummary;
import software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse;

public class ListArtifactsPublisher
implements SdkPublisher<ListArtifactsResponse> {
    private final SageMakerAsyncClient client;
    private final ListArtifactsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListArtifactsPublisher(SageMakerAsyncClient client, ListArtifactsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListArtifactsPublisher(SageMakerAsyncClient client, ListArtifactsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListArtifactsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListArtifactsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ArtifactSummary> artifactSummaries() {
        Function<ListArtifactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.artifactSummaries() != null) {
                return response.artifactSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListArtifactsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListArtifactsResponseFetcher
    implements AsyncPageFetcher<ListArtifactsResponse> {
        private ListArtifactsResponseFetcher() {
        }

        public boolean hasNextPage(ListArtifactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListArtifactsResponse> nextPage(ListArtifactsResponse previousPage) {
            if (previousPage == null) {
                return ListArtifactsPublisher.this.client.listArtifacts(ListArtifactsPublisher.this.firstRequest);
            }
            return ListArtifactsPublisher.this.client.listArtifacts((ListArtifactsRequest)((Object)ListArtifactsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

