/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary;

public class ListNotebookInstancesIterable
implements SdkIterable<ListNotebookInstancesResponse> {
    private final SageMakerClient client;
    private final ListNotebookInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNotebookInstancesIterable(SageMakerClient client, ListNotebookInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNotebookInstancesResponseFetcher();
    }

    public Iterator<ListNotebookInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NotebookInstanceSummary> notebookInstances() {
        Function<ListNotebookInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.notebookInstances() != null) {
                return response.notebookInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNotebookInstancesResponseFetcher
    implements SyncPageFetcher<ListNotebookInstancesResponse> {
        private ListNotebookInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListNotebookInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNotebookInstancesResponse nextPage(ListNotebookInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListNotebookInstancesIterable.this.client.listNotebookInstances(ListNotebookInstancesIterable.this.firstRequest);
            }
            return ListNotebookInstancesIterable.this.client.listNotebookInstances((ListNotebookInstancesRequest)((Object)ListNotebookInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

