/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsApiGatewayEndpointConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsApiGatewayEndpointConfiguration> {
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Types").getter(AwsApiGatewayEndpointConfiguration.getter(AwsApiGatewayEndpointConfiguration::types)).setter(AwsApiGatewayEndpointConfiguration.setter(Builder::types)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> types;

    private AwsApiGatewayEndpointConfiguration(BuilderImpl builder) {
        this.types = builder.types;
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<String> types() {
        return this.types;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.types() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiGatewayEndpointConfiguration)) {
            return false;
        }
        AwsApiGatewayEndpointConfiguration other = (AwsApiGatewayEndpointConfiguration)obj;
        return this.hasTypes() == other.hasTypes() && Objects.equals(this.types(), other.types());
    }

    public final String toString() {
        return ToString.builder((String)"AwsApiGatewayEndpointConfiguration").add("Types", this.hasTypes() ? this.types() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Types": {
                return Optional.ofNullable(clazz.cast(this.types()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsApiGatewayEndpointConfiguration, T> g) {
        return obj -> g.apply((AwsApiGatewayEndpointConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiGatewayEndpointConfiguration model) {
            this.types(model.types);
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = NonEmptyStringListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public final void setTypes(Collection<String> types) {
            this.types = NonEmptyStringListCopier.copy(types);
        }

        public AwsApiGatewayEndpointConfiguration build() {
            return new AwsApiGatewayEndpointConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsApiGatewayEndpointConfiguration> {
        public Builder types(Collection<String> var1);

        public Builder types(String ... var1);
    }
}

