/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IntegrationType {
    SEND_FINDINGS_TO_SECURITY_HUB("SEND_FINDINGS_TO_SECURITY_HUB"),
    RECEIVE_FINDINGS_FROM_SECURITY_HUB("RECEIVE_FINDINGS_FROM_SECURITY_HUB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IntegrationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IntegrationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IntegrationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IntegrationType> knownValues() {
        return Stream.of(IntegrationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

