/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.model.ExecutionParameterMapCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteProvisionedProductServiceActionRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, ExecuteProvisionedProductServiceActionRequest> {
    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionedProductId").getter(ExecuteProvisionedProductServiceActionRequest.getter(ExecuteProvisionedProductServiceActionRequest::provisionedProductId)).setter(ExecuteProvisionedProductServiceActionRequest.setter(Builder::provisionedProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build()}).build();
    private static final SdkField<String> SERVICE_ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceActionId").getter(ExecuteProvisionedProductServiceActionRequest.getter(ExecuteProvisionedProductServiceActionRequest::serviceActionId)).setter(ExecuteProvisionedProductServiceActionRequest.setter(Builder::serviceActionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionId").build()}).build();
    private static final SdkField<String> EXECUTE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecuteToken").getter(ExecuteProvisionedProductServiceActionRequest.getter(ExecuteProvisionedProductServiceActionRequest::executeToken)).setter(ExecuteProvisionedProductServiceActionRequest.setter(Builder::executeToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecuteToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(ExecuteProvisionedProductServiceActionRequest.getter(ExecuteProvisionedProductServiceActionRequest::acceptLanguage)).setter(ExecuteProvisionedProductServiceActionRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(ExecuteProvisionedProductServiceActionRequest.getter(ExecuteProvisionedProductServiceActionRequest::parameters)).setter(ExecuteProvisionedProductServiceActionRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_PRODUCT_ID_FIELD, SERVICE_ACTION_ID_FIELD, EXECUTE_TOKEN_FIELD, ACCEPT_LANGUAGE_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecuteProvisionedProductServiceActionRequest.memberNameToFieldInitializer();
    private final String provisionedProductId;
    private final String serviceActionId;
    private final String executeToken;
    private final String acceptLanguage;
    private final Map<String, List<String>> parameters;

    private ExecuteProvisionedProductServiceActionRequest(BuilderImpl builder) {
        super(builder);
        this.provisionedProductId = builder.provisionedProductId;
        this.serviceActionId = builder.serviceActionId;
        this.executeToken = builder.executeToken;
        this.acceptLanguage = builder.acceptLanguage;
        this.parameters = builder.parameters;
    }

    public final String provisionedProductId() {
        return this.provisionedProductId;
    }

    public final String serviceActionId() {
        return this.serviceActionId;
    }

    public final String executeToken() {
        return this.executeToken;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> parameters() {
        return this.parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceActionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteProvisionedProductServiceActionRequest)) {
            return false;
        }
        ExecuteProvisionedProductServiceActionRequest other = (ExecuteProvisionedProductServiceActionRequest)((Object)obj);
        return Objects.equals(this.provisionedProductId(), other.provisionedProductId()) && Objects.equals(this.serviceActionId(), other.serviceActionId()) && Objects.equals(this.executeToken(), other.executeToken()) && Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteProvisionedProductServiceActionRequest").add("ProvisionedProductId", (Object)this.provisionedProductId()).add("ServiceActionId", (Object)this.serviceActionId()).add("ExecuteToken", (Object)this.executeToken()).add("AcceptLanguage", (Object)this.acceptLanguage()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedProductId": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductId()));
            }
            case "ServiceActionId": {
                return Optional.ofNullable(clazz.cast(this.serviceActionId()));
            }
            case "ExecuteToken": {
                return Optional.ofNullable(clazz.cast(this.executeToken()));
            }
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProvisionedProductId", PROVISIONED_PRODUCT_ID_FIELD);
        map.put("ServiceActionId", SERVICE_ACTION_ID_FIELD);
        map.put("ExecuteToken", EXECUTE_TOKEN_FIELD);
        map.put("AcceptLanguage", ACCEPT_LANGUAGE_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteProvisionedProductServiceActionRequest, T> g) {
        return obj -> g.apply((ExecuteProvisionedProductServiceActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String provisionedProductId;
        private String serviceActionId;
        private String executeToken;
        private String acceptLanguage;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteProvisionedProductServiceActionRequest model) {
            super(model);
            this.provisionedProductId(model.provisionedProductId);
            this.serviceActionId(model.serviceActionId);
            this.executeToken(model.executeToken);
            this.acceptLanguage(model.acceptLanguage);
            this.parameters(model.parameters);
        }

        public final String getProvisionedProductId() {
            return this.provisionedProductId;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final String getServiceActionId() {
            return this.serviceActionId;
        }

        public final void setServiceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
        }

        @Override
        public final Builder serviceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
            return this;
        }

        public final String getExecuteToken() {
            return this.executeToken;
        }

        public final void setExecuteToken(String executeToken) {
            this.executeToken = executeToken;
        }

        @Override
        public final Builder executeToken(String executeToken) {
            this.executeToken = executeToken;
            return this;
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ExecutionParameterMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ExecutionParameterMapCopier.copy(parameters);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteProvisionedProductServiceActionRequest build() {
            return new ExecuteProvisionedProductServiceActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteProvisionedProductServiceActionRequest> {
        public Builder provisionedProductId(String var1);

        public Builder serviceActionId(String var1);

        public Builder executeToken(String var1);

        public Builder acceptLanguage(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

