/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sfn.model.EncryptionConfiguration;
import software.amazon.awssdk.services.sfn.model.LoggingConfiguration;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.services.sfn.model.StateMachineStatus;
import software.amazon.awssdk.services.sfn.model.StateMachineType;
import software.amazon.awssdk.services.sfn.model.TracingConfiguration;
import software.amazon.awssdk.services.sfn.model.VariableReferencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStateMachineResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, DescribeStateMachineResponse> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateMachineArn").getter(DescribeStateMachineResponse.getter(DescribeStateMachineResponse::stateMachineArn)).setter(DescribeStateMachineResponse.setter(Builder::stateMachineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DescribeStateMachineResponse.getter(DescribeStateMachineResponse::name)).setter(DescribeStateMachineResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeStateMachineResponse.getter(DescribeStateMachineResponse::statusAsString)).setter(DescribeStateMachineResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definition").getter(DescribeStateMachineResponse.getter(DescribeStateMachineResponse::definition)).setter(DescribeStateMachineResponse.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DescribeStateMachineResponse.getter(DescribeStateMachineResponse::roleArn)).setter(DescribeStateMachineResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(DescribeStateMachineResponse.getter(DescribeStateMachineResponse::typeAsString)).setter(DescribeStateMachineResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(DescribeStateMachineResponse.getter(DescribeStateMachineResponse::creationDate)).setter(DescribeStateMachineResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("loggingConfiguration").getter(DescribeStateMachineResponse.getter(DescribeStateMachineResponse::loggingConfiguration)).setter(DescribeStateMachineResponse.setter(Builder::loggingConfiguration)).constructor(LoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfiguration").build()}).build();
    private static final SdkField<TracingConfiguration> TRACING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tracingConfiguration").getter(DescribeStateMachineResponse.getter(DescribeStateMachineResponse::tracingConfiguration)).setter(DescribeStateMachineResponse.setter(Builder::tracingConfiguration)).constructor(TracingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingConfiguration").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("label").getter(DescribeStateMachineResponse.getter(DescribeStateMachineResponse::label)).setter(DescribeStateMachineResponse.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(DescribeStateMachineResponse.getter(DescribeStateMachineResponse::revisionId)).setter(DescribeStateMachineResponse.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DescribeStateMachineResponse.getter(DescribeStateMachineResponse::description)).setter(DescribeStateMachineResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(DescribeStateMachineResponse.getter(DescribeStateMachineResponse::encryptionConfiguration)).setter(DescribeStateMachineResponse.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final SdkField<Map<String, List<String>>> VARIABLE_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("variableReferences").getter(DescribeStateMachineResponse.getter(DescribeStateMachineResponse::variableReferences)).setter(DescribeStateMachineResponse.setter(Builder::variableReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableReferences").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD, NAME_FIELD, STATUS_FIELD, DEFINITION_FIELD, ROLE_ARN_FIELD, TYPE_FIELD, CREATION_DATE_FIELD, LOGGING_CONFIGURATION_FIELD, TRACING_CONFIGURATION_FIELD, LABEL_FIELD, REVISION_ID_FIELD, DESCRIPTION_FIELD, ENCRYPTION_CONFIGURATION_FIELD, VARIABLE_REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeStateMachineResponse.memberNameToFieldInitializer();
    private final String stateMachineArn;
    private final String name;
    private final String status;
    private final String definition;
    private final String roleArn;
    private final String type;
    private final Instant creationDate;
    private final LoggingConfiguration loggingConfiguration;
    private final TracingConfiguration tracingConfiguration;
    private final String label;
    private final String revisionId;
    private final String description;
    private final EncryptionConfiguration encryptionConfiguration;
    private final Map<String, List<String>> variableReferences;

    private DescribeStateMachineResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.status = builder.status;
        this.definition = builder.definition;
        this.roleArn = builder.roleArn;
        this.type = builder.type;
        this.creationDate = builder.creationDate;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.tracingConfiguration = builder.tracingConfiguration;
        this.label = builder.label;
        this.revisionId = builder.revisionId;
        this.description = builder.description;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.variableReferences = builder.variableReferences;
    }

    public final String stateMachineArn() {
        return this.stateMachineArn;
    }

    public final String name() {
        return this.name;
    }

    public final StateMachineStatus status() {
        return StateMachineStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String definition() {
        return this.definition;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final StateMachineType type() {
        return StateMachineType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final LoggingConfiguration loggingConfiguration() {
        return this.loggingConfiguration;
    }

    public final TracingConfiguration tracingConfiguration() {
        return this.tracingConfiguration;
    }

    public final String label() {
        return this.label;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final String description() {
        return this.description;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final boolean hasVariableReferences() {
        return this.variableReferences != null && !(this.variableReferences instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> variableReferences() {
        return this.variableReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariableReferences() ? this.variableReferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStateMachineResponse)) {
            return false;
        }
        DescribeStateMachineResponse other = (DescribeStateMachineResponse)((Object)obj);
        return Objects.equals(this.stateMachineArn(), other.stateMachineArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.loggingConfiguration(), other.loggingConfiguration()) && Objects.equals(this.tracingConfiguration(), other.tracingConfiguration()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && this.hasVariableReferences() == other.hasVariableReferences() && Objects.equals(this.variableReferences(), other.variableReferences());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStateMachineResponse").add("StateMachineArn", (Object)this.stateMachineArn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Definition", (Object)(this.definition() == null ? null : "*** Sensitive Data Redacted ***")).add("RoleArn", (Object)this.roleArn()).add("Type", (Object)this.typeAsString()).add("CreationDate", (Object)this.creationDate()).add("LoggingConfiguration", (Object)this.loggingConfiguration()).add("TracingConfiguration", (Object)this.tracingConfiguration()).add("Label", (Object)this.label()).add("RevisionId", (Object)this.revisionId()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("VariableReferences", (Object)(this.variableReferences() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachineArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "loggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.loggingConfiguration()));
            }
            case "tracingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.tracingConfiguration()));
            }
            case "label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "variableReferences": {
                return Optional.ofNullable(clazz.cast(this.variableReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stateMachineArn", STATE_MACHINE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("loggingConfiguration", LOGGING_CONFIGURATION_FIELD);
        map.put("tracingConfiguration", TRACING_CONFIGURATION_FIELD);
        map.put("label", LABEL_FIELD);
        map.put("revisionId", REVISION_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("variableReferences", VARIABLE_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStateMachineResponse, T> g) {
        return obj -> g.apply((DescribeStateMachineResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private String stateMachineArn;
        private String name;
        private String status;
        private String definition;
        private String roleArn;
        private String type;
        private Instant creationDate;
        private LoggingConfiguration loggingConfiguration;
        private TracingConfiguration tracingConfiguration;
        private String label;
        private String revisionId;
        private String description;
        private EncryptionConfiguration encryptionConfiguration;
        private Map<String, List<String>> variableReferences = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStateMachineResponse model) {
            super(model);
            this.stateMachineArn(model.stateMachineArn);
            this.name(model.name);
            this.status(model.status);
            this.definition(model.definition);
            this.roleArn(model.roleArn);
            this.type(model.type);
            this.creationDate(model.creationDate);
            this.loggingConfiguration(model.loggingConfiguration);
            this.tracingConfiguration(model.tracingConfiguration);
            this.label(model.label);
            this.revisionId(model.revisionId);
            this.description(model.description);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.variableReferences(model.variableReferences);
        }

        public final String getStateMachineArn() {
            return this.stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StateMachineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(StateMachineType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return this.loggingConfiguration != null ? this.loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final TracingConfiguration.Builder getTracingConfiguration() {
            return this.tracingConfiguration != null ? this.tracingConfiguration.toBuilder() : null;
        }

        public final void setTracingConfiguration(TracingConfiguration.BuilderImpl tracingConfiguration) {
            this.tracingConfiguration = tracingConfiguration != null ? tracingConfiguration.build() : null;
        }

        @Override
        public final Builder tracingConfiguration(TracingConfiguration tracingConfiguration) {
            this.tracingConfiguration = tracingConfiguration;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getVariableReferences() {
            if (this.variableReferences instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.variableReferences;
        }

        public final void setVariableReferences(Map<String, ? extends Collection<String>> variableReferences) {
            this.variableReferences = VariableReferencesCopier.copy(variableReferences);
        }

        @Override
        public final Builder variableReferences(Map<String, ? extends Collection<String>> variableReferences) {
            this.variableReferences = VariableReferencesCopier.copy(variableReferences);
            return this;
        }

        @Override
        public DescribeStateMachineResponse build() {
            return new DescribeStateMachineResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStateMachineResponse> {
        public Builder stateMachineArn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(StateMachineStatus var1);

        public Builder definition(String var1);

        public Builder roleArn(String var1);

        public Builder type(String var1);

        public Builder type(StateMachineType var1);

        public Builder creationDate(Instant var1);

        public Builder loggingConfiguration(LoggingConfiguration var1);

        default public Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return this.loggingConfiguration((LoggingConfiguration)((LoggingConfiguration.Builder)LoggingConfiguration.builder().applyMutation(loggingConfiguration)).build());
        }

        public Builder tracingConfiguration(TracingConfiguration var1);

        default public Builder tracingConfiguration(Consumer<TracingConfiguration.Builder> tracingConfiguration) {
            return this.tracingConfiguration((TracingConfiguration)((TracingConfiguration.Builder)TracingConfiguration.builder().applyMutation(tracingConfiguration)).build());
        }

        public Builder label(String var1);

        public Builder revisionId(String var1);

        public Builder description(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder variableReferences(Map<String, ? extends Collection<String>> var1);
    }
}

