/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.Ec2AmiResource;
import software.amazon.awssdk.services.snowball.model.Ec2AmiResourceListCopier;
import software.amazon.awssdk.services.snowball.model.LambdaResource;
import software.amazon.awssdk.services.snowball.model.LambdaResourceListCopier;
import software.amazon.awssdk.services.snowball.model.S3Resource;
import software.amazon.awssdk.services.snowball.model.S3ResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobResource> {
    private static final SdkField<List<S3Resource>> S3_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("S3Resources").getter(JobResource.getter(JobResource::s3Resources)).setter(JobResource.setter(Builder::s3Resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LambdaResource>> LAMBDA_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LambdaResources").getter(JobResource.getter(JobResource::lambdaResources)).setter(JobResource.setter(Builder::lambdaResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LambdaResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Ec2AmiResource>> EC2_AMI_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ec2AmiResources").getter(JobResource.getter(JobResource::ec2AmiResources)).setter(JobResource.setter(Builder::ec2AmiResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2AmiResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ec2AmiResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_RESOURCES_FIELD, LAMBDA_RESOURCES_FIELD, EC2_AMI_RESOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<S3Resource> s3Resources;
    private final List<LambdaResource> lambdaResources;
    private final List<Ec2AmiResource> ec2AmiResources;

    private JobResource(BuilderImpl builder) {
        this.s3Resources = builder.s3Resources;
        this.lambdaResources = builder.lambdaResources;
        this.ec2AmiResources = builder.ec2AmiResources;
    }

    public final boolean hasS3Resources() {
        return this.s3Resources != null && !(this.s3Resources instanceof SdkAutoConstructList);
    }

    public final List<S3Resource> s3Resources() {
        return this.s3Resources;
    }

    public final boolean hasLambdaResources() {
        return this.lambdaResources != null && !(this.lambdaResources instanceof SdkAutoConstructList);
    }

    public final List<LambdaResource> lambdaResources() {
        return this.lambdaResources;
    }

    public final boolean hasEc2AmiResources() {
        return this.ec2AmiResources != null && !(this.ec2AmiResources instanceof SdkAutoConstructList);
    }

    public final List<Ec2AmiResource> ec2AmiResources() {
        return this.ec2AmiResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3Resources() ? this.s3Resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLambdaResources() ? this.lambdaResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2AmiResources() ? this.ec2AmiResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobResource)) {
            return false;
        }
        JobResource other = (JobResource)obj;
        return this.hasS3Resources() == other.hasS3Resources() && Objects.equals(this.s3Resources(), other.s3Resources()) && this.hasLambdaResources() == other.hasLambdaResources() && Objects.equals(this.lambdaResources(), other.lambdaResources()) && this.hasEc2AmiResources() == other.hasEc2AmiResources() && Objects.equals(this.ec2AmiResources(), other.ec2AmiResources());
    }

    public final String toString() {
        return ToString.builder((String)"JobResource").add("S3Resources", this.hasS3Resources() ? this.s3Resources() : null).add("LambdaResources", this.hasLambdaResources() ? this.lambdaResources() : null).add("Ec2AmiResources", this.hasEc2AmiResources() ? this.ec2AmiResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Resources": {
                return Optional.ofNullable(clazz.cast(this.s3Resources()));
            }
            case "LambdaResources": {
                return Optional.ofNullable(clazz.cast(this.lambdaResources()));
            }
            case "Ec2AmiResources": {
                return Optional.ofNullable(clazz.cast(this.ec2AmiResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobResource, T> g) {
        return obj -> g.apply((JobResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<S3Resource> s3Resources = DefaultSdkAutoConstructList.getInstance();
        private List<LambdaResource> lambdaResources = DefaultSdkAutoConstructList.getInstance();
        private List<Ec2AmiResource> ec2AmiResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobResource model) {
            this.s3Resources(model.s3Resources);
            this.lambdaResources(model.lambdaResources);
            this.ec2AmiResources(model.ec2AmiResources);
        }

        public final Collection<S3Resource.Builder> getS3Resources() {
            if (this.s3Resources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.s3Resources != null ? (Collection)this.s3Resources.stream().map(S3Resource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder s3Resources(Collection<S3Resource> s3Resources) {
            this.s3Resources = S3ResourceListCopier.copy(s3Resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(S3Resource ... s3Resources) {
            this.s3Resources(Arrays.asList(s3Resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(Consumer<S3Resource.Builder> ... s3Resources) {
            this.s3Resources(Stream.of(s3Resources).map(c -> (S3Resource)((S3Resource.Builder)S3Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setS3Resources(Collection<S3Resource.BuilderImpl> s3Resources) {
            this.s3Resources = S3ResourceListCopier.copyFromBuilder(s3Resources);
        }

        public final Collection<LambdaResource.Builder> getLambdaResources() {
            if (this.lambdaResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lambdaResources != null ? (Collection)this.lambdaResources.stream().map(LambdaResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lambdaResources(Collection<LambdaResource> lambdaResources) {
            this.lambdaResources = LambdaResourceListCopier.copy(lambdaResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaResources(LambdaResource ... lambdaResources) {
            this.lambdaResources(Arrays.asList(lambdaResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaResources(Consumer<LambdaResource.Builder> ... lambdaResources) {
            this.lambdaResources(Stream.of(lambdaResources).map(c -> (LambdaResource)((LambdaResource.Builder)LambdaResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLambdaResources(Collection<LambdaResource.BuilderImpl> lambdaResources) {
            this.lambdaResources = LambdaResourceListCopier.copyFromBuilder(lambdaResources);
        }

        public final Collection<Ec2AmiResource.Builder> getEc2AmiResources() {
            if (this.ec2AmiResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ec2AmiResources != null ? (Collection)this.ec2AmiResources.stream().map(Ec2AmiResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ec2AmiResources(Collection<Ec2AmiResource> ec2AmiResources) {
            this.ec2AmiResources = Ec2AmiResourceListCopier.copy(ec2AmiResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2AmiResources(Ec2AmiResource ... ec2AmiResources) {
            this.ec2AmiResources(Arrays.asList(ec2AmiResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2AmiResources(Consumer<Ec2AmiResource.Builder> ... ec2AmiResources) {
            this.ec2AmiResources(Stream.of(ec2AmiResources).map(c -> (Ec2AmiResource)((Ec2AmiResource.Builder)Ec2AmiResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEc2AmiResources(Collection<Ec2AmiResource.BuilderImpl> ec2AmiResources) {
            this.ec2AmiResources = Ec2AmiResourceListCopier.copyFromBuilder(ec2AmiResources);
        }

        public JobResource build() {
            return new JobResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobResource> {
        public Builder s3Resources(Collection<S3Resource> var1);

        public Builder s3Resources(S3Resource ... var1);

        public Builder s3Resources(Consumer<S3Resource.Builder> ... var1);

        public Builder lambdaResources(Collection<LambdaResource> var1);

        public Builder lambdaResources(LambdaResource ... var1);

        public Builder lambdaResources(Consumer<LambdaResource.Builder> ... var1);

        public Builder ec2AmiResources(Collection<Ec2AmiResource> var1);

        public Builder ec2AmiResources(Ec2AmiResource ... var1);

        public Builder ec2AmiResources(Consumer<Ec2AmiResource.Builder> ... var1);
    }
}

