/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sns.model.MapStringToStringCopier;
import software.amazon.awssdk.services.sns.model.SnsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePlatformEndpointRequest
extends SnsRequest
implements ToCopyableBuilder<Builder, CreatePlatformEndpointRequest> {
    private static final SdkField<String> PLATFORM_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformApplicationArn").getter(CreatePlatformEndpointRequest.getter(CreatePlatformEndpointRequest::platformApplicationArn)).setter(CreatePlatformEndpointRequest.setter(Builder::platformApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformApplicationArn").build()}).build();
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Token").getter(CreatePlatformEndpointRequest.getter(CreatePlatformEndpointRequest::token)).setter(CreatePlatformEndpointRequest.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Token").build()}).build();
    private static final SdkField<String> CUSTOM_USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomUserData").getter(CreatePlatformEndpointRequest.getter(CreatePlatformEndpointRequest::customUserData)).setter(CreatePlatformEndpointRequest.setter(Builder::customUserData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomUserData").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(CreatePlatformEndpointRequest.getter(CreatePlatformEndpointRequest::attributes)).setter(CreatePlatformEndpointRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_APPLICATION_ARN_FIELD, TOKEN_FIELD, CUSTOM_USER_DATA_FIELD, ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePlatformEndpointRequest.memberNameToFieldInitializer();
    private final String platformApplicationArn;
    private final String token;
    private final String customUserData;
    private final Map<String, String> attributes;

    private CreatePlatformEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.platformApplicationArn = builder.platformApplicationArn;
        this.token = builder.token;
        this.customUserData = builder.customUserData;
        this.attributes = builder.attributes;
    }

    public final String platformApplicationArn() {
        return this.platformApplicationArn;
    }

    public final String token() {
        return this.token;
    }

    public final String customUserData() {
        return this.customUserData;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.platformApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        hashCode = 31 * hashCode + Objects.hashCode(this.customUserData());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformEndpointRequest)) {
            return false;
        }
        CreatePlatformEndpointRequest other = (CreatePlatformEndpointRequest)((Object)obj);
        return Objects.equals(this.platformApplicationArn(), other.platformApplicationArn()) && Objects.equals(this.token(), other.token()) && Objects.equals(this.customUserData(), other.customUserData()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePlatformEndpointRequest").add("PlatformApplicationArn", (Object)this.platformApplicationArn()).add("Token", (Object)this.token()).add("CustomUserData", (Object)this.customUserData()).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.platformApplicationArn()));
            }
            case "Token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
            case "CustomUserData": {
                return Optional.ofNullable(clazz.cast(this.customUserData()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PlatformApplicationArn", PLATFORM_APPLICATION_ARN_FIELD);
        map.put("Token", TOKEN_FIELD);
        map.put("CustomUserData", CUSTOM_USER_DATA_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePlatformEndpointRequest, T> g) {
        return obj -> g.apply((CreatePlatformEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnsRequest.BuilderImpl
    implements Builder {
        private String platformApplicationArn;
        private String token;
        private String customUserData;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformEndpointRequest model) {
            super(model);
            this.platformApplicationArn(model.platformApplicationArn);
            this.token(model.token);
            this.customUserData(model.customUserData);
            this.attributes(model.attributes);
        }

        public final String getPlatformApplicationArn() {
            return this.platformApplicationArn;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        @Override
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final String getToken() {
            return this.token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final String getCustomUserData() {
            return this.customUserData;
        }

        public final void setCustomUserData(String customUserData) {
            this.customUserData = customUserData;
        }

        @Override
        public final Builder customUserData(String customUserData) {
            this.customUserData = customUserData;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlatformEndpointRequest build() {
            return new CreatePlatformEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SnsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePlatformEndpointRequest> {
        public Builder platformApplicationArn(String var1);

        public Builder token(String var1);

        public Builder customUserData(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

