/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PatchProperty {
    PRODUCT("PRODUCT"),
    PRODUCT_FAMILY("PRODUCT_FAMILY"),
    CLASSIFICATION("CLASSIFICATION"),
    MSRC_SEVERITY("MSRC_SEVERITY"),
    PRIORITY("PRIORITY"),
    SEVERITY("SEVERITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PatchProperty> VALUE_MAP;
    private final String value;

    private PatchProperty(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PatchProperty fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PatchProperty> knownValues() {
        EnumSet<PatchProperty> knownValues = EnumSet.allOf(PatchProperty.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PatchProperty.class, PatchProperty::toString);
    }
}

