/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse;
import software.amazon.awssdk.services.ssm.model.ScheduledWindowExecution;

public class DescribeMaintenanceWindowSchedulePublisher
implements SdkPublisher<DescribeMaintenanceWindowScheduleResponse> {
    private final SsmAsyncClient client;
    private final DescribeMaintenanceWindowScheduleRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMaintenanceWindowSchedulePublisher(SsmAsyncClient client, DescribeMaintenanceWindowScheduleRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMaintenanceWindowSchedulePublisher(SsmAsyncClient client, DescribeMaintenanceWindowScheduleRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMaintenanceWindowScheduleResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMaintenanceWindowScheduleResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScheduledWindowExecution> scheduledWindowExecutions() {
        Function<DescribeMaintenanceWindowScheduleResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduledWindowExecutions() != null) {
                return response.scheduledWindowExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeMaintenanceWindowScheduleResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeMaintenanceWindowScheduleResponseFetcher
    implements AsyncPageFetcher<DescribeMaintenanceWindowScheduleResponse> {
        private DescribeMaintenanceWindowScheduleResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMaintenanceWindowScheduleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMaintenanceWindowScheduleResponse> nextPage(DescribeMaintenanceWindowScheduleResponse previousPage) {
            if (previousPage == null) {
                return DescribeMaintenanceWindowSchedulePublisher.this.client.describeMaintenanceWindowSchedule(DescribeMaintenanceWindowSchedulePublisher.this.firstRequest);
            }
            return DescribeMaintenanceWindowSchedulePublisher.this.client.describeMaintenanceWindowSchedule((DescribeMaintenanceWindowScheduleRequest)((Object)DescribeMaintenanceWindowSchedulePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

